/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.application;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSSOProvider;
import com.sun.identity.authentication.modules.application.ApplicationPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;

public class Application
extends AMLoginModule {
    private String userTokenId = null;
    private Principal userPrincipal = null;
    private String errorMsg = null;
    private static String secret = null;
    private static final String amAuthApplication = "amAuthApplication";
    private static Debug debug = Debug.getInstance((String)"amAuthApplication");
    private ResourceBundle bundle = null;
    private LDAPAuthUtils ldapUtil;
    private Map currentConfig;
    private static boolean ldapSSL = false;

    public void init(Subject subject, Map sharedState, Map options) {
        try {
            debug.message("in initialize...");
            Locale locale = this.getLoginLocale();
            this.bundle = amCache.getResBundle(amAuthApplication, locale);
            if (debug.messageEnabled()) {
                debug.message("ApplicationAuth resbundle locale=" + locale);
            }
        }
        catch (Exception e) {
            debug.error("ApplicationAuthModule Init: " + e.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)e);
            }
            this.errorMsg = "appInitFalied";
        }
        if (secret == null || secret.length() == 0) {
            debug.message("Init : NULL secret in AMConfig.properties");
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthApplication, this.errorMsg, null);
        }
        HttpServletRequest req = this.getHttpServletRequest();
        String userName = null;
        String newUserName = null;
        String secretParam = null;
        if (req != null) {
            userName = req.getParameter("IDToken0");
            secretParam = req.getParameter("IDToken1");
            if (userName == null && secretParam == null) {
                userName = req.getParameter("Login.Token0");
                secretParam = req.getParameter("Login.Token1");
            }
        }
        if (secretParam == null && userName == null) {
            Map map = this.sendCallback();
            if (map == null || map.isEmpty()) {
                throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
            }
            secretParam = (String)map.get("secret");
            userName = (String)map.get("uid");
        }
        if (secretParam == null || secretParam.length() == 0) {
            throw new AuthLoginException(amAuthApplication, "noPassword", null);
        }
        if (secret != null && secret.length() != 0 && secretParam.equals(secret)) {
            if (debug.messageEnabled()) {
                debug.message("App.validate, secret matched for user : " + userName);
            }
            newUserName = userName == null || userName.length() == 0 ? "amService-gateway" : "amService-" + userName;
            String userDNString = "cn=" + newUserName + "," + "ou=DSAME Users" + "," + SMSEntry.getRootSuffix();
            if (!this.isValidUserEntry(userDNString)) {
                debug.message(userDNString + " is not a valid special user entry");
                if (!this.doFallbackAuth(userName, secretParam)) {
                    debug.error("App validation failed, User not Valid: " + userName);
                    this.setFailureID(userName);
                    throw new AuthLoginException(amAuthApplication, "userInvalid", null);
                }
            } else {
                this.userTokenId = userDNString;
            }
        } else if (!this.doFallbackAuth(userName, secretParam)) {
            debug.error("App validation failed, User not Valid: " + userName);
            this.setFailureID(userName);
            throw new AuthLoginException(amAuthApplication, "userInvalid", null);
        }
        return -1;
    }

    private boolean doFallbackAuth(String userName, String userPassword) throws AuthLoginException {
        boolean success = false;
        if (debug.messageEnabled()) {
            debug.message("doFallbackAuth : User = " + userName);
        }
        if (userName != null && userName.length() != 0) {
            if (this.internalAuth(userName, userPassword)) {
                if (debug.messageEnabled()) {
                    debug.message("Internal Auth is successful : User = " + this.userTokenId);
                }
                success = true;
            } else if (this.authenticateToDatastore(userName, userPassword)) {
                if (debug.messageEnabled()) {
                    debug.message("Application.doFallbackAuth: Authenticating to DataStore Auth Module.");
                }
                if (this.userTokenId == null) {
                    this.userTokenId = userName;
                }
                success = true;
            } else if (this.authenticateToLDAP(userName, userPassword) == 26) {
                if (this.userTokenId == null) {
                    this.userTokenId = this.ldapUtil.getUserId();
                }
                if (debug.messageEnabled()) {
                    debug.message("Auth is successful,returning User = " + this.userTokenId);
                }
                success = true;
            }
        }
        return success;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new ApplicationPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    private Map sendCallback() {
        try {
            CallbackHandler callbackHandler = this.getCallbackHandler();
            if (callbackHandler == null) {
                throw new AuthLoginException(amAuthApplication, "NoCallbackHandler", null);
            }
            Callback[] callbacks = new Callback[]{new NameCallback(this.bundle.getString("appname")), new PasswordCallback(this.bundle.getString("secret"), true)};
            if (debug.messageEnabled()) {
                debug.message("Callback is.. :" + callbacks);
            }
            callbackHandler.handle(callbacks);
            HashMap<String, String> map = new HashMap<String, String>();
            int len = callbacks.length;
            for (int i = 0; i < len; ++i) {
                String username;
                Callback cb = callbacks[i];
                if (cb instanceof PasswordCallback) {
                    char[] pass = ((PasswordCallback)cb).getPassword();
                    if (pass == null) continue;
                    map.put("secret", new String(pass));
                    continue;
                }
                if (!(cb instanceof NameCallback) || (username = ((NameCallback)cb).getName()) == null) continue;
                map.put("uid", username);
            }
            return map;
        }
        catch (Exception e) {
            debug.error("sendCallback: " + e.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int authenticateToLDAP(String userName, String userPassword) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("In authenticateToLDAP with User : " + userName);
        }
        try {
            if (this.isSuperAdmin(userName)) {
                this.ldapUtil = new LDAPAuthUtils(AuthD.directoryHostName, AuthD.directoryPort, ldapSSL, this.bundle, debug);
                this.ldapUtil.authenticateSuperAdmin(userName, userPassword);
                if (this.ldapUtil.getState() == 26) {
                    this.userTokenId = userName;
                    return this.ldapUtil.getState();
                }
                debug.message("Invalid adminID or admin Password");
                this.setFailureID(this.ldapUtil.getUserId(userName));
                throw new AuthLoginException(amAuthApplication, "InvalidUP", null);
            }
            if (this.initLDAPAttributes("iPlanetAMAuthLDAPService")) {
                this.ldapUtil.authenticateUser(userName, userPassword);
                return this.ldapUtil.getState();
            }
            debug.message("Invalid userID or user Password");
            this.setFailureID(userName);
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null);
        }
        catch (LDAPUtilException ex) {
            this.setFailureID(userName);
            switch (ex.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist.");
                    throw new AuthLoginException(amAuthApplication, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password.");
                    String failureUserID = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(amAuthApplication, "InvalidUP", null, failureUserID, (Throwable)((Object)ex));
                }
            }
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null);
        }
    }

    private boolean authenticateToDatastore(String userName, String userPassword) throws AuthLoginException {
        boolean retval;
        block2: {
            retval = false;
            Callback[] callbacks = new Callback[2];
            NameCallback nameCallback = new NameCallback("NamePrompt");
            nameCallback.setName(userName);
            callbacks[0] = nameCallback;
            PasswordCallback passwordCallback = new PasswordCallback("PasswordPrompt", false);
            passwordCallback.setPassword(userPassword.toCharArray());
            callbacks[1] = passwordCallback;
            try {
                AMIdentityRepository idrepo = this.getAMIdentityRepository(this.getRequestOrg());
                retval = idrepo.authenticate(callbacks);
            }
            catch (IdRepoException idrepoExp) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Application.authenticateToDatastore:  IdRepo Exception", (Throwable)idrepoExp);
            }
        }
        return retval;
    }

    private boolean initLDAPAttributes(String serviceName) throws AuthLoginException {
        String serverHost = null;
        this.currentConfig = this.getOrgServiceTemplate(this.getRequestOrg(), serviceName);
        try {
            serverHost = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server");
            if (serverHost == null) {
                debug.message("No server for configuring");
                return false;
            }
            String baseDN = CollectionHelper.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-base-dn");
            if (baseDN == null) {
                debug.error("Fatal error: baseDN for search has invalid value");
                throw new AuthLoginException(amAuthApplication, "basednnull", null);
            }
            String bindDN = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-dn", (String)"");
            String bindPassword = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-passwd", (String)"");
            String userNamingAttr = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-user-naming-attribute", (String)"uid");
            Set userSearchAttrs = (Set)this.currentConfig.get("iplanet-am-auth-ldap-user-search-attributes");
            String searchFilter = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-filter", (String)"");
            boolean ssl = Boolean.valueOf(CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-ssl-enabled", (String)"false"));
            String tmp = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-scope", (String)"SUBTREE");
            int searchScope = 2;
            if (tmp.equalsIgnoreCase("OBJECT")) {
                searchScope = 0;
            } else if (tmp.equalsIgnoreCase("ONELEVEL")) {
                searchScope = 1;
            }
            String returnUserDN = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
            int index = serverHost.indexOf(58);
            int serverPort = 389;
            String port = null;
            if (index != -1) {
                port = serverHost.substring(index + 1);
                serverPort = Integer.parseInt(port);
                serverHost = serverHost.substring(0, index);
            }
            this.ldapUtil = new LDAPAuthUtils(serverHost, serverPort, ssl, this.bundle, baseDN, debug);
            this.ldapUtil.setScope(searchScope);
            this.ldapUtil.setFilter(searchFilter);
            this.ldapUtil.setUserNamingAttribute(userNamingAttr);
            this.ldapUtil.setUserSearchAttribute(userSearchAttrs);
            this.ldapUtil.setAuthPassword(bindPassword);
            this.ldapUtil.setAuthDN(bindDN);
            this.ldapUtil.setReturnUserDN(returnUserDN);
            if (debug.messageEnabled()) {
                debug.message("bindDN-> " + bindDN + "\nbaseDN-> " + baseDN + "\nuserNamingAttr-> " + userNamingAttr + "\nuserSearchAttr(s)-> " + userSearchAttrs + "\nsearchFilter-> " + searchFilter + "\nsearchScope-> " + searchScope + "\nssl-> " + ssl + "\nHost: " + serverHost + "\nINDEDX : " + index + "\nPORT : " + serverPort);
            }
            return true;
        }
        catch (Exception ex) {
            debug.error("LDAP Init Exception", (Throwable)ex);
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null, ex);
        }
    }

    private boolean internalAuth(String userName, String userPassword) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("In internalAuth with User : " + userName);
        }
        try {
            AuthContext ac = new AuthContext(new AuthPrincipal(userName), userPassword.toCharArray());
            if (ac.getLoginStatus() == 3) {
                this.userTokenId = ac.getSSOToken().getPrincipal().getName();
                debug.message("InternalAuth is successful");
                AuthSSOProvider authSSOProvider = new AuthSSOProvider();
                authSSOProvider.destroyToken(ac.getSSOToken());
                return true;
            }
        }
        catch (Exception ex) {
            debug.message("Internal Authentication Exception : " + ex.getMessage());
        }
        return false;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.errorMsg = null;
        this.bundle = null;
        this.ldapUtil = null;
        this.currentConfig = null;
    }

    static {
        debug.message("Application module getting secret");
        String tmp = SystemProperties.get("com.iplanet.am.service.secret").trim();
        secret = (String)AccessController.doPrivileged(new DecodeAction(tmp));
        ldapSSL = Boolean.valueOf(SystemProperties.get("com.iplanet.am.directory.ssl.enabled", "false"));
    }
}

