/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.distUI;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.UI.AuthViewBeanBase;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LogoutViewBean
extends AuthViewBeanBase {
    public static final String PAGE_NAME = "Logout";
    static Debug logoutDebug = Debug.getInstance((String)"amLogoutViewBean");
    HttpServletRequest request;
    HttpServletResponse response;
    HttpSession session;
    ServletContext servletContext;
    Locale locale = null;
    String orgName = "";
    String indexName = "";
    AuthContext.IndexType indexType;
    String client_type = "";
    public String ResultVal = "";
    public String gotoUrl = "";
    public String jsp_page = "";
    private static String LOGINURL = "";
    private String loginURL = "";
    public ResourceBundle rb = null;
    private static final String LOGOUTCOOKIEVAULE = "LOGOUT";
    private String logoutCookie = null;
    private boolean cookieSupported;
    public static final String URL_LOGIN = "urlLogin";
    public static final String TXT_LOGOUT = "txtLogout";
    public static final String TXT_GOTO_LOGIN_AFTER_LOGOUT = "txtGotoLoginAfterLogout";
    public static final String HTML_TITLE_LOGOUT = "htmlTitle_Logout";
    private String clientType = null;
    private static final String LOGOUT_JSP = "Logout.jsp";
    private static final String LOGIN_JSP = "Login.jsp";
    private static final String bundleName = "amAuthUI";
    private boolean ssoTokenExists = false;

    public LogoutViewBean() {
        super(PAGE_NAME);
        logoutDebug.message("LogoutViewBean() constructor called");
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(URL_LOGIN, StaticTextField.class);
        this.registerChild(TXT_LOGOUT, StaticTextField.class);
        this.registerChild(TXT_GOTO_LOGIN_AFTER_LOGOUT, StaticTextField.class);
    }

    public void forwardTo(RequestContext requestContext) {
        logoutDebug.message("In forwardTo()");
        if (requestContext != null) {
            this.request = requestContext.getRequest();
            this.response = requestContext.getResponse();
            this.servletContext = requestContext.getServletContext();
            this.session = this.request.getSession();
        }
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Expires", "0");
        this.gotoUrl = this.request.getParameter("goto");
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("Goto query param : " + this.gotoUrl);
        }
        try {
            this.cookieSupported = AuthClientUtils.checkForCookies(this.request);
            this.client_type = AuthClientUtils.getClientType(this.request);
            ISLocaleContext localeContext = new ISLocaleContext();
            localeContext.setLocale(this.request);
            this.locale = localeContext.getLocale();
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SessionID sessionID = AuthClientUtils.getSessionIDFromRequest(this.request);
            SSOToken ssoToken = AuthClientUtils.getExistingValidSSOToken(sessionID);
            if (ssoToken != null) {
                this.ssoTokenExists = true;
                this.loginURL = ssoToken.getProperty("DistAuthLoginURL");
                this.orgName = ssoToken.getProperty("Organization");
                String strIndexType = ssoToken.getProperty("IndexType");
                if (strIndexType != null) {
                    this.indexType = AuthClientUtils.getIndexType(strIndexType);
                    this.indexName = AuthClientUtils.getIndexName(ssoToken, this.indexType);
                }
            }
            manager.destroyToken(ssoToken);
            logoutDebug.message("logout successfully");
            this.rb = rbCache.getResBundle(bundleName, this.locale);
            this.ResultVal = this.rb.getString("logout.successful");
            if (logoutDebug.messageEnabled()) {
                logoutDebug.message("Client Type is: " + this.client_type);
                logoutDebug.message("JSPLocale = " + this.locale);
                logoutDebug.message("loginURL : " + this.loginURL);
            }
            this.fallbackLocale = this.locale;
            this.rb = rbCache.getResBundle(bundleName, this.locale);
        }
        catch (Exception e) {
            logoutDebug.message("Retrieve AuthContext Error : ", (Throwable)e);
            this.ResultVal = this.getL10NMessage(e, this.locale);
        }
        if (this.cookieSupported) {
            logoutDebug.message("Cookie is supported");
            this.clearAllCookies();
        } else {
            logoutDebug.message("Cookie is not supported");
            this.logoutCookie = LOGOUTCOOKIEVAULE;
            if (logoutDebug.messageEnabled()) {
                logoutDebug.message("Logout Cookie is " + this.logoutCookie);
            }
        }
        this.session.invalidate();
        this.jsp_page = this.appendLogoutCookie(this.getFileName(LOGOUT_JSP));
        if (!this.ssoTokenExists && !this.isGotoSet()) {
            try {
                if (logoutDebug.messageEnabled()) {
                    logoutDebug.message("AuthContext is NULL");
                    logoutDebug.message("Goto LOGINURL : " + LOGINURL);
                }
                if (this.doSendRedirect(LOGINURL)) {
                    this.response.sendRedirect(this.appendLogoutCookie(LOGINURL));
                    return;
                }
                this.jsp_page = this.appendLogoutCookie(this.getFileName(LOGIN_JSP));
            }
            catch (Exception e) {
                this.ResultVal = this.getL10NMessage(e, this.locale);
            }
        }
        if (!this.redirectToGoto(this.locale)) {
            super.forwardTo(requestContext);
        }
    }

    private String getFileName(String fileName) {
        String relativeFileName = null;
        relativeFileName = this.ssoTokenExists ? AuthClientUtils.getFileName(fileName, this.locale.toString(), this.orgName, this.request, this.servletContext, this.indexType, this.indexName) : AuthClientUtils.getDefaultFileName(this.request, fileName, this.locale, this.servletContext);
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("fileName is : " + fileName);
            logoutDebug.message("relativeFileName is : " + relativeFileName);
        }
        return relativeFileName;
    }

    private void clearAllCookies() {
        Set cookieDomainSet = AuthClientUtils.getCookieDomains();
        if (cookieDomainSet.isEmpty()) {
            this.clearAllCookiesByDomain(null);
        } else {
            Iterator iter = cookieDomainSet.iterator();
            while (iter.hasNext()) {
                this.clearAllCookiesByDomain((String)iter.next());
            }
        }
        AuthClientUtils.clearlbCookie(this.response);
        this.clearHostUrlCookie(this.response);
        Object serverCookieMap = null;
        if (storeCookies != null && !storeCookies.isEmpty()) {
            Iterator it = storeCookies.iterator();
            while (it.hasNext()) {
                String cookieName = (String)it.next();
                AuthClientUtils.clearServerCookie(cookieName, this.response);
            }
        }
    }

    private void clearAllCookiesByDomain(String cookieDomain) {
        Cookie cookie = AuthClientUtils.createCookie(LOGOUTCOOKIEVAULE, cookieDomain);
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
        if (AuthClientUtils.getAuthCookieValue(this.request) != null) {
            cookie = AuthClientUtils.createCookie(AuthClientUtils.getAuthCookieName(), LOGOUTCOOKIEVAULE, cookieDomain);
            cookie.setMaxAge(0);
            this.response.addCookie(cookie);
        }
    }

    public String getDisplayURL() {
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("In getDisplayURL() jsp_page " + this.jsp_page);
        }
        return this.jsp_page;
    }

    protected View createChild(String name) {
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("In createChild() : child name = " + name);
        }
        if (name.equals(TXT_LOGOUT)) {
            return new StaticTextField((ContainerView)this, name, (Object)this.ResultVal);
        }
        if (name.equals(TXT_GOTO_LOGIN_AFTER_LOGOUT)) {
            return new StaticTextField((ContainerView)this, name, (Object)"");
        }
        if (name.equals(URL_LOGIN)) {
            if (this.loginURL == null || this.loginURL.length() == 0) {
                this.loginURL = LOGINURL;
            }
            this.loginURL = this.appendLogoutCookie(this.loginURL);
            return new StaticTextField((ContainerView)this, name, (Object)this.loginURL);
        }
        if (name.equals(HTML_TITLE_LOGOUT)) {
            String logoutTitle = this.rb.getString(HTML_TITLE_LOGOUT);
            return new StaticTextField((ContainerView)this, name, (Object)logoutTitle);
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        logoutDebug.message("In beginDisplay()");
        this.setPageEncoding(this.request, this.response);
    }

    private String appendLogoutCookie(String url) {
        return AuthClientUtils.addLogoutCookieToURL(url, this.logoutCookie, this.cookieSupported);
    }

    private boolean doSendRedirect(String redirectURL) {
        return redirectURL != null && redirectURL.length() != 0 && AuthClientUtils.isGenericHTMLClient(this.clientType);
    }

    private boolean isGotoSet() {
        return this.gotoUrl != null && this.gotoUrl.length() != 0;
    }

    private boolean redirectToGoto(Locale locale) {
        if (this.isGotoSet()) {
            if (logoutDebug.messageEnabled()) {
                logoutDebug.message("Redirect to 'goto' URL : " + this.gotoUrl);
            }
            try {
                if (this.doSendRedirect(this.gotoUrl)) {
                    this.response.sendRedirect(this.appendLogoutCookie(this.gotoUrl));
                    return true;
                }
            }
            catch (Exception e) {
                if (logoutDebug.messageEnabled()) {
                    logoutDebug.message("'goto' Redirect failed : " + this.gotoUrl, (Throwable)e);
                }
                this.ResultVal = this.getL10NMessage(e, locale);
            }
        }
        return false;
    }

    public void handleHrefLogoutRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.forwardTo();
    }

    public boolean beginHrefLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    public boolean beginContentHrefLogoutDisplay(ChildDisplayEvent event) {
        this.setDisplayFieldValue(TXT_GOTO_LOGIN_AFTER_LOGOUT, this.rb.getString("gotoLoginAfterLogout"));
        return true;
    }

    public boolean beginStaticTextLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    public String getTileIndex() {
        return "";
    }

    public boolean beginContentStaticTextLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    private String getL10NMessage(Exception e, Locale locale) {
        if (e instanceof L10NMessage) {
            return ((L10NMessage)e).getL10NMessage(locale);
        }
        return e.getMessage();
    }

    static {
        LOGINURL = serviceUri + "/UI/Login";
    }
}

