/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigType;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMSDKEventListener;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.security.auth.login.ConfigFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class AMConfiguration
extends Configuration {
    private static Map jaasConfig = new HashMap();
    private static Map listenersMap = new HashMap();
    private static ConfigFile configFile = null;
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private Configuration defConfig = null;
    private SSOToken adminToken = null;
    private AMAuthenticationManager amAM = null;
    private static ServiceConfigManager scm = null;

    public AMConfiguration(Configuration config) {
        this.defConfig = config;
        this.adminToken = AuthD.getAuth().getSSOAuthSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        debug.message("inside AMConfiguration.initialize()");
        Map map = jaasConfig;
        synchronized (map) {
            jaasConfig = new HashMap();
        }
        map = listenersMap;
        synchronized (map) {
            listenersMap = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfigurationEntry[] cloneConfigurationEntry(AppConfigurationEntry[] entries, String orgDN) {
        if (debug.messageEnabled()) {
            debug.message("AMConfiguration.cloneConfigurationEntry, orgDN=" + orgDN + ", entries=" + entries);
        }
        ArrayList<AppConfigurationEntry> list = new ArrayList<AppConfigurationEntry>();
        Set supportedModules = null;
        if (AuthD.revisionNumber < 30 && (supportedModules = this.amAM.getAllowedModuleNames()).isEmpty()) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = entries;
        synchronized (entries) {
            int i;
            int len = entries.length;
            for (i = 0; i < len; ++i) {
                String tmp = entries[i].getLoginModuleName();
                if (AuthD.revisionNumber < 30 && !tmp.equals("Application") && !supportedModules.contains(AMAuthConfigUtils.getModuleName(tmp))) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("skip module " + tmp);
                    continue;
                }
                list.add(new AppConfigurationEntry(entries[i].getLoginModuleName(), entries[i].getControlFlag(), entries[i].getOptions()));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            int len2 = list.size();
            if (len2 == 0) {
                return null;
            }
            AppConfigurationEntry[] clone = new AppConfigurationEntry[len2];
            for (i = 0; i < len2; ++i) {
                clone[i] = (AppConfigurationEntry)list.get(i);
            }
            return clone;
        }
    }

    private String getOrganization(String configName) {
        return new AMAuthConfigType(configName).getOrganization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfigurationEntry[] newConfiguration(String name) {
        if (debug.messageEnabled()) {
            debug.message("newConfig, name = " + name);
        }
        AMAuthConfigType type = new AMAuthConfigType(name);
        AppConfigurationEntry[] entries = null;
        try {
            switch (type.getIndexType()) {
                case 1: {
                    entries = this.getUserBasedConfig(type.getOrganization(), type.getIndexName(), name);
                    break;
                }
                case 2: {
                    entries = this.getOrgBasedConfig(type.getOrganization(), name, false);
                    break;
                }
                case 3: {
                    entries = this.getRoleBasedConfig(type.getOrganization(), type.getIndexName(), name);
                    break;
                }
                case 4: {
                    if (type.getIndexName().equals("adminconsoleservice")) {
                        entries = this.getOrgBasedConfig(type.getOrganization(), name, true);
                        break;
                    }
                    entries = this.getServiceBasedConfig(type.getOrganization(), type.getIndexName(), name);
                    break;
                }
                case 5: {
                    entries = this.getModuleBasedConfig(type.getOrganization(), type.getIndexName(), name);
                    break;
                }
                default: {
                    if (debug.messageEnabled()) {
                        debug.message("Unable to find config " + name + " in Access Manager config");
                    }
                    debug.message("Getting default configuration.");
                    if (this.defConfig != null) {
                        entries = this.defConfig.getAppConfigurationEntry(name);
                    }
                    if (entries == null) {
                        if (configFile == null) {
                            configFile = new ConfigFile();
                        }
                        debug.message("Getting configuration from confFile.");
                        entries = configFile.getAppConfigurationEntry(name);
                    }
                    if (entries == null) {
                        debug.error("newConfiguration, invalid config " + name);
                    }
                    return entries;
                }
            }
        }
        catch (Exception e) {
            debug.error("newConfiguration.switch", (Throwable)e);
        }
        if (entries == null) {
            if (debug.messageEnabled()) {
                debug.message("newConfig, config not defined " + name);
            }
            return null;
        }
        Map map = jaasConfig;
        synchronized (map) {
            jaasConfig.put(name, entries);
        }
        return this.cloneConfigurationEntry(entries, type.getOrganization());
    }

    private String getServiceNameForModule(String name) {
        int dot = name.lastIndexOf(46);
        String moduleName = dot != -1 ? name.substring(dot + 1) : name;
        return AuthUtils.getModuleServiceName(moduleName);
    }

    private String getLoginModuleClassName(String module) {
        return AuthD.getAuth().getAuthenticatorForName(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfigurationEntry[] getOrgBasedConfig(String orgDN, String name, boolean isConsole) {
        if (debug.messageEnabled()) {
            debug.message("getOrgBasedConfig,  START " + orgDN);
        }
        try {
            if (scm == null) {
                Map map = jaasConfig;
                synchronized (map) {
                    scm = new ServiceConfigManager("iPlanetAMAuthService", this.adminToken);
                }
            }
            ServiceConfig service = scm.getOrganizationConfig(orgDN, null);
            Map attrs = service.getAttributes();
            Set configValues = isConsole ? (Set)attrs.get("iplanet-am-auth-admin-auth-module") : (Set)attrs.get("iplanet-am-auth-org-config");
            String configName = null;
            if (configValues != null) {
                configName = (String)configValues.iterator().next();
            }
            if (debug.messageEnabled()) {
                debug.message("org auth config = " + configName);
            }
            AppConfigurationEntry[] ret = this.parseInstanceConfiguration(orgDN, configName, name);
            this.addServiceListener("iPlanetAMAuthService", name);
            return ret;
        }
        catch (Exception e) {
            debug.error("getOrgBasedConfig org=" + orgDN, (Throwable)e);
            return null;
        }
    }

    private AppConfigurationEntry[] parseInstanceConfiguration(String orgDN, String config, String name) throws SMSException, SSOException {
        String configName = config.trim();
        if (configName == null || configName.length() == 0 || configName.equals("[Empty]")) {
            return null;
        }
        if (configName.indexOf(32) != -1) {
            if (debug.messageEnabled()) {
                debug.message("Old DIT with chain config");
            }
            return this.parseXMLConfig(configName, name);
        }
        if (debug.messageEnabled()) {
            debug.message("New DIT with named service config");
        }
        return this.getServiceBasedConfig(orgDN, configName, name);
    }

    private AppConfigurationEntry[] parseXMLConfig(String xmlConfig, String name) throws SMSException, SSOException {
        AppConfigurationEntry[] entries = AMAuthConfigUtils.parseValues(xmlConfig);
        if (entries == null) {
            return null;
        }
        int len = entries.length;
        AppConfigurationEntry[] ret = new AppConfigurationEntry[len];
        for (int i = 0; i < len; ++i) {
            AMAuthenticationInstance instance;
            String className = entries[i].getLoginModuleName();
            int dot = className.lastIndexOf(46);
            String moduleName = className;
            if (dot != -1) {
                moduleName = className.substring(dot + 1);
            }
            if ((instance = this.amAM.getAuthenticationInstance(moduleName)) == null) {
                return null;
            }
            Map attribs = instance.getAttributeValues();
            if (attribs == null) {
                return null;
            }
            if (dot == -1) {
                String type = instance.getType();
                className = this.getLoginModuleClassName(type);
            }
            attribs.putAll(entries[i].getOptions());
            attribs.put("moduleInstanceName", moduleName);
            ret[i] = new AppConfigurationEntry(className, entries[i].getControlFlag(), attribs);
            this.addServiceListener(AuthUtils.getModuleServiceName(instance.getType()), name);
        }
        return ret;
    }

    private AppConfigurationEntry[] getUserBasedConfig(String orgDN, String universalId, String name) {
        if (debug.messageEnabled()) {
            debug.message("getUserBasedConfig,  START " + orgDN + "|" + universalId);
        }
        try {
            AMIdentity identity = IdUtils.getIdentity(this.adminToken, universalId);
            if (identity != null) {
                Set configNames = identity.getAttribute("iplanet-am-user-auth-config");
                if (configNames == null || configNames.isEmpty()) {
                    return null;
                }
                String configName = (String)configNames.iterator().next();
                if (debug.messageEnabled()) {
                    debug.message("Named config for user " + universalId + " = " + configName);
                }
                AppConfigurationEntry[] ret = this.parseInstanceConfiguration(orgDN, configName, name);
                return ret;
            }
            if (debug.warningEnabled()) {
                debug.warning("User Based Config, user not exist " + universalId);
            }
            return null;
        }
        catch (Exception e) {
            debug.error("getUserBasedConfig " + universalId + "|" + orgDN, (Throwable)e);
            return null;
        }
    }

    private AppConfigurationEntry[] getServiceBasedConfig(String orgDN, String service, String name) {
        if (debug.messageEnabled()) {
            debug.message("ServiceBasedConfig,  START " + orgDN + "|" + service + ", name = " + name);
        }
        if (service == null) {
            return null;
        }
        try {
            Map attributeDataMap = AMAuthConfigUtils.getNamedConfig(service, orgDN, this.adminToken);
            Set xmlConfigValue = (Set)attributeDataMap.get("iplanet-am-auth-configuration");
            String xmlConfig = null;
            if (xmlConfigValue != null && !xmlConfigValue.isEmpty()) {
                xmlConfig = (String)xmlConfigValue.iterator().next();
            }
            if (xmlConfig == null) {
                return null;
            }
            AppConfigurationEntry[] ret = this.parseXMLConfig(xmlConfig, name);
            if (debug.messageEnabled()) {
                debug.message("serviceBased, add SM listener on " + service);
            }
            this.addServiceListener("iPlanetAMAuthConfiguration", name);
            if (debug.messageEnabled()) {
                debug.message("ServiceBasedConfig, return config " + service + ", org=" + orgDN);
            }
            return ret;
        }
        catch (Exception e) {
            debug.error("getServiceBasedConfig " + service + "|" + orgDN, (Throwable)e);
            return null;
        }
    }

    private AppConfigurationEntry[] getRoleBasedConfig(String orgDN, String roleUniversalId, String name) {
        if (debug.messageEnabled()) {
            debug.message("RoleBasedConfig,  START " + orgDN + "|" + roleUniversalId);
        }
        try {
            AMIdentity identity = IdUtils.getIdentity(this.adminToken, roleUniversalId);
            if (identity != null) {
                Set configNames = (Set)identity.getServiceAttributes("iPlanetAMAuthConfiguration").get("iplanet-am-auth-configuration");
                if (configNames == null) {
                    return null;
                }
                String configName = (String)configNames.iterator().next();
                if (debug.messageEnabled()) {
                    debug.message("Named config for role " + roleUniversalId + " = " + configName);
                }
                AppConfigurationEntry[] ret = this.parseInstanceConfiguration(orgDN, configName, name);
                return ret;
            }
            if (debug.warningEnabled()) {
                debug.warning("RoleBaseConfig, role not exist " + roleUniversalId);
            }
            return null;
        }
        catch (Exception e) {
            debug.error("getRoleBasedConfig " + orgDN + "|" + roleUniversalId, (Throwable)e);
            return null;
        }
    }

    private AppConfigurationEntry[] getModuleBasedConfig(String orgDN, String module, String name) {
        if (debug.messageEnabled()) {
            debug.message("ModuleBasedConfig,  START " + orgDN + "|" + module + ", name = " + name);
        }
        try {
            AMAuthenticationInstance instance = this.amAM.getAuthenticationInstance(module);
            if (instance == null) {
                return null;
            }
            Map attribs = instance.getAttributeValues();
            attribs.put("moduleInstanceName", module);
            String type = instance.getType();
            AppConfigurationEntry[] ret = new AppConfigurationEntry[]{new AppConfigurationEntry(this.getLoginModuleClassName(type), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, attribs)};
            this.addServiceListener(AuthUtils.getModuleServiceName(type), name);
            if (debug.messageEnabled()) {
                debug.message("ModuleBaseConfig, return config " + module + ", " + orgDN);
            }
            return ret;
        }
        catch (Exception e) {
            debug.error("getModuleBasedConfig " + orgDN + "|" + module, (Throwable)e);
            return null;
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String configName) {
        if (debug.messageEnabled()) {
            debug.message("retrieving configuration: " + configName);
            debug.message("cached configs " + jaasConfig);
        }
        if (configName == null) {
            return null;
        }
        AMAuthConfigType type = new AMAuthConfigType(configName);
        String orgDN = type.getOrganization();
        try {
            this.amAM = new AMAuthenticationManager(this.adminToken, orgDN);
        }
        catch (Exception e) {
            debug.error("Failed to obtain AMAuthenticationManager: " + e.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)e);
            }
            return null;
        }
        AppConfigurationEntry[] entry = (AppConfigurationEntry[])jaasConfig.get(configName);
        if (entry != null) {
            if (debug.messageEnabled()) {
                debug.message("getAppConfigurationEntry[], found " + configName);
            }
            return this.cloneConfigurationEntry(entry, this.getOrganization(configName));
        }
        if (debug.messageEnabled()) {
            debug.message("getAppConfigurationEntry[], new " + configName);
        }
        return this.newConfiguration(configName);
    }

    public void refresh() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processListenerEvent(String name) {
        Map map = jaasConfig;
        synchronized (map) {
            if (debug.messageEnabled()) {
                debug.message("pLE, remove config " + name);
            }
            jaasConfig.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListenersMap(String name) {
        Map map = listenersMap;
        synchronized (map) {
            Set set = (Set)listenersMap.get(name);
            if (set == null) {
                if (debug.messageEnabled()) {
                    debug.message("remove, no listeners for " + name);
                }
                return;
            }
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AMSDKEventListener l = (AMSDKEventListener)it.next();
                if (debug.messageEnabled()) {
                    debug.message("remove SDK listener on " + name + " for dn=" + l.getListenedObject().getDN());
                }
                l.getListenedObject().removeEventListener(l);
                l.setListenedObject(null);
            }
            listenersMap.remove(name);
        }
        AMAuthLevelManager.getInstance().removeAuthConfigListener(name);
    }

    private void addServiceListener(String service, String name) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("addServiceListener for " + service + ", name=" + name);
        }
        AMAuthLevelManager.getInstance().addAuthConfigListener(service, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToListenersMap(String name, Object listener) {
        Map map = listenersMap;
        synchronized (map) {
            HashSet<Object> set = (HashSet<Object>)listenersMap.get(name);
            if (set == null) {
                set = new HashSet<Object>();
                set.add(listener);
                listenersMap.put(name, set);
            } else {
                set.add(listener);
            }
        }
    }
}

