/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMAuthenticationInstance {
    private String moduleName;
    private String moduleType;
    private ServiceConfig serviceConfig = null;
    private ServiceSchema globalSchema = null;

    protected AMAuthenticationInstance(String name, String type, ServiceConfig config, ServiceSchema global) {
        this.moduleName = name;
        this.moduleType = type;
        this.serviceConfig = config;
        this.globalSchema = global;
    }

    public String getName() {
        return this.moduleName;
    }

    public String getType() {
        return this.moduleType;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public Map getAttributeValues() {
        Map org = null;
        if (this.serviceConfig != null) {
            org = this.serviceConfig.getAttributes();
        }
        Map global = null;
        if (this.globalSchema != null) {
            global = this.globalSchema.getAttributeDefaults();
        }
        HashMap totalAttrs = new HashMap();
        if (global != null) {
            totalAttrs.putAll(global);
        }
        if (org != null) {
            totalAttrs.putAll(org);
        }
        return totalAttrs;
    }

    public Map getAttributeValues(Set names) {
        Map allAttrs = this.getAttributeValues();
        HashMap attrs = new HashMap();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!allAttrs.containsKey(key)) continue;
            attrs.put(key, allAttrs.get(key));
        }
        return attrs;
    }

    public void setAttributeValues(Map values) throws SMSException, SSOException {
        if (this.serviceConfig != null) {
            this.serviceConfig.setAttributes(values);
        }
    }

    public void setAttribute(String name, Set values) throws SMSException, SSOException {
        if (this.serviceConfig != null) {
            this.serviceConfig.addAttribute(name, values);
        }
    }
}

