/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.sun.identity.shared.debug.Debug;

public class AMAuthConfigType {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    protected static final int USER = 1;
    protected static final int ORGANIZATION = 2;
    protected static final int ROLE = 3;
    protected static final int SERVICE = 4;
    protected static final int MODULE = 5;
    private String configName;
    private String orgDN;
    private String indexName;
    private String clientType;
    private int indexType = 0;

    AMAuthConfigType(String name) {
        if (name.startsWith("MODULE")) {
            int orgP = name.indexOf(";ORGANIZATION=");
            int cliP = name.indexOf(";CLIENT=");
            if (orgP == -1 || cliP == -1) {
                debug.error("Invalid module config name " + name);
                return;
            }
            this.indexType = 5;
            this.indexName = name.substring("MODULE".length() + 1, orgP);
            this.orgDN = name.substring(orgP + "ORGANIZATION".length() + 2, cliP);
            this.clientType = name.substring(cliP + "CLIENT".length() + 2);
        } else if (name.startsWith("USER")) {
            int orgP = name.indexOf(";ORGANIZATION=");
            int cliP = name.indexOf(";CLIENT=");
            if (orgP == -1 || cliP == -1) {
                debug.error("Invalid module config name " + name);
                return;
            }
            this.indexType = 1;
            this.indexName = name.substring("USER".length() + 1, orgP);
            this.orgDN = name.substring(orgP + "ORGANIZATION".length() + 2, cliP);
            this.clientType = name.substring(cliP + "CLIENT".length() + 2);
        } else if (name.startsWith("ORGANIZATION")) {
            int cliP = name.indexOf(";CLIENT=");
            if (cliP == -1) {
                debug.error("Invalid module config name " + name);
                return;
            }
            this.indexType = 2;
            this.orgDN = this.indexName = name.substring("ORGANIZATION".length() + 1, cliP);
            this.clientType = name.substring(cliP + "CLIENT".length() + 2);
        } else if (name.startsWith("SERVICE")) {
            int orgP = name.indexOf(";ORGANIZATION=");
            int cliP = name.indexOf(";CLIENT=");
            if (orgP == -1 || cliP == -1) {
                debug.error("Invalid module config name " + name);
                return;
            }
            this.indexType = 4;
            this.indexName = name.substring("SERVICE".length() + 1, orgP);
            this.orgDN = name.substring(orgP + "ORGANIZATION".length() + 2, cliP);
            this.clientType = name.substring(cliP + "CLIENT".length() + 2);
        } else if (name.startsWith("ROLE")) {
            int orgP = name.indexOf(";ORGANIZATION=");
            int cliP = name.indexOf(";CLIENT=");
            if (orgP == -1 || cliP == -1) {
                debug.error("Invalid module config name " + name);
                return;
            }
            this.indexType = 3;
            this.indexName = name.substring("ROLE".length() + 1, orgP);
            this.orgDN = name.substring(orgP + "ORGANIZATION".length() + 2, cliP);
            this.clientType = name.substring(cliP + "CLIENT".length() + 2);
        } else {
            debug.message("Invalid index type in config name " + name);
        }
        if (debug.messageEnabled()) {
            debug.message("indexType = " + this.indexType + "\nindexName=" + this.indexName + "\norgDN=" + this.orgDN + "\nclientType=" + this.clientType);
        }
    }

    String getOrganization() {
        return this.orgDN;
    }

    String getClientType() {
        return this.clientType;
    }

    String getIndexName() {
        return this.indexName;
    }

    int getIndexType() {
        return this.indexType;
    }
}

