/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class UMSException
extends Exception {
    private static final long serialVersionUID = -7043204896844472780L;
    static ResourceBundle xcptMsgs = null;
    protected String xcptMessage;
    protected Throwable rootCause;

    public UMSException(String message) {
        super(message);
        this.xcptMessage = message;
    }

    public UMSException(String message, Throwable rootCause) {
        super(message);
        this.xcptMessage = message;
        this.rootCause = rootCause;
    }

    protected UMSException() {
        this.xcptMessage = null;
    }

    public String getMessage() {
        if (this.getRootCause() == null) {
            return this.xcptMessage;
        }
        StringBuffer theMsg = new StringBuffer();
        String nestedMsg = this.rootCause instanceof LDAPException ? ((LDAPException)this.rootCause).getLDAPErrorMessage() : this.rootCause.getMessage();
        if (this.xcptMessage != null) {
            theMsg.append(this.xcptMessage).append("::").append(nestedMsg);
        } else {
            theMsg.append(nestedMsg);
        }
        return theMsg.toString();
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public PrintWriter log(PrintWriter out) {
        return UMSException.log(this, out);
    }

    public static PrintWriter log(Throwable xcpt, PrintWriter out) {
        out.println("-----------");
        out.println(xcpt.toString());
        out.println("Stack Trace:");
        out.print(UMSException.getStackTrace(xcpt));
        out.println("-----------");
        out.flush();
        return out;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("--------------------------------------");
        buf.append("Got UMS Exception\n");
        String msg = this.getMessage();
        if (msg != null && msg.length() > 0) {
            buf.append("Message: ").append(this.getMessage());
        }
        if (this.rootCause != null) {
            buf.append("\nLower level exception: ");
            buf.append(this.getRootCause());
        }
        return buf.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        if (this.rootCause != null) {
            String superString = super.toString();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString + (superString.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootCause.printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        if (this.rootCause != null) {
            String superString = super.toString();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString + (superString.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootCause.printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }

    private static String getStackTrace(Throwable xcpt) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        xcpt.printStackTrace(pw);
        return sw.toString();
    }
}

