/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AttributeValueAlreadyExistsException;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.UMSException;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class SchemaManager
implements Serializable,
IUMSConstants {
    public static final String ATTRIBUTE_SYNTAX_CIS = "1.3.6.1.4.1.1466.115.121.1.15";
    public static final String ATTRIBUTE_SYNTAX_CES = "1.3.6.1.4.1.1466.115.121.1.26";
    public static final String ATTRIBUTE_SYNTAX_BINARY = "1.3.6.1.4.1.1466.115.121.1.5";
    public static final String ATTRIBUTE_SYNTAX_INT = "1.3.6.1.4.1.1466.115.121.1.27";
    public static final String ATTRIBUTE_SYNTAX_TELEPHONE = "1.3.6.1.4.1.1466.115.121.1.50";
    public static final String ATTRIBUTE_SYNTAX_DN = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final int STRUCTURAL = 0;
    public static final int ABSTRACT = 1;
    public static final int AUXILIARY = 2;
    private static I18n i18n = I18n.getInstance("amSDK");
    private Principal m_principal;
    private DataLayer m_datalayer;
    private LDAPSchema m_schema;
    private boolean m_hasModified;

    protected SchemaManager() {
    }

    protected SchemaManager(Principal principal) throws UMSException {
        this.m_datalayer = DataLayer.getInstance();
        this.m_principal = principal;
    }

    public static SchemaManager getSchemaManager(SSOToken token) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        Principal principal = null;
        try {
            principal = token.getPrincipal();
        }
        catch (Exception e) {
            return null;
        }
        return new SchemaManager(principal);
    }

    public static SchemaManager getSchemaManager(Principal principal) throws UMSException {
        return new SchemaManager(principal);
    }

    private LDAPSchema getLDAPSchema() throws UMSException {
        if (this.m_schema == null || this.m_hasModified) {
            this.refresh();
            this.m_hasModified = false;
        }
        return this.m_schema;
    }

    public void refresh() throws UMSException {
        this.m_schema = this.m_datalayer.getSchema(this.m_principal);
    }

    public void addAttribute(String name, String oid, String description, String syntax, boolean single) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPAttributeSchema newAttrType = new LDAPAttributeSchema(name, oid, description, syntax, single);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)newAttrType);
        this.m_hasModified = true;
    }

    public void addAttribute(String raw) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPAttributeSchema newAttrType = new LDAPAttributeSchema(raw);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)newAttrType);
        this.m_hasModified = true;
    }

    public void addObjectClass(String name, String oid, String superior, String description, String[] required, String[] optional) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema newObjClass = new LDAPObjectClassSchema(name, oid, superior, description, required, optional);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)newObjClass);
        this.m_hasModified = true;
    }

    public void addObjectClass(String name, String oid, String[] superior, String description, String[] required, String[] optional, int type, String[] aliases) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema newObjClass = new LDAPObjectClassSchema(name, oid, superior, description, required, optional, type, aliases);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)newObjClass);
        this.m_hasModified = true;
    }

    public void addObjectClass(String raw) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema newObjClass = new LDAPObjectClassSchema(raw);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)newObjClass);
        this.m_hasModified = true;
    }

    public void removeAttribute(String name) throws UMSException {
        LDAPAttributeSchema attrType = this.getLDAPSchema().getAttribute(name);
        if (attrType == null) {
            Object[] args = new String[]{name};
            String msg = i18n.getString("ums-attributetypenotfound", args);
            throw new UMSException(msg);
        }
        this.m_datalayer.removeSchema(this.m_principal, (LDAPSchemaElement)attrType);
        this.m_hasModified = true;
    }

    public void removeObjectClass(String name) throws UMSException {
        LDAPObjectClassSchema objClass = this.getLDAPSchema().getObjectClass(name);
        if (objClass == null) {
            Object[] args = new String[]{name};
            String msg = i18n.getString("ums-objectclassnotfound", args);
            throw new UMSException(msg);
        }
        this.m_datalayer.removeSchema(this.m_principal, (LDAPSchemaElement)objClass);
        this.m_hasModified = true;
    }

    public String getAttribute(String name) throws UMSException {
        LDAPAttributeSchema attrType = this.getLDAPSchema().getAttribute(name);
        if (attrType != null) {
            return attrType.getValue();
        }
        return null;
    }

    public String getObjectClass(String name) throws UMSException {
        LDAPObjectClassSchema objClass = this.getLDAPSchema().getObjectClass(name);
        if (objClass != null) {
            return objClass.getValue();
        }
        return null;
    }

    public Collection getObjectClasses(String attrName) throws UMSException {
        ArrayList<String> objClassNames = new ArrayList<String>();
        Enumeration objClasses = this.getLDAPSchema().getObjectClasses();
        while (objClasses.hasMoreElements()) {
            String name;
            LDAPObjectClassSchema objClass = (LDAPObjectClassSchema)objClasses.nextElement();
            Enumeration requiredAttrNames = objClass.getRequiredAttributes();
            Enumeration optionalAttrNames = objClass.getOptionalAttributes();
            while (requiredAttrNames.hasMoreElements()) {
                name = (String)requiredAttrNames.nextElement();
                if (!name.equalsIgnoreCase(attrName)) continue;
                objClassNames.add(objClass.getName());
            }
            while (optionalAttrNames.hasMoreElements()) {
                name = (String)optionalAttrNames.nextElement();
                if (!name.equalsIgnoreCase(attrName)) continue;
                objClassNames.add(objClass.getName());
            }
        }
        return objClassNames;
    }

    public Collection getAttributes(String objClassName) throws UMSException {
        Collection attributes = this.getRequiredAttributes(objClassName);
        attributes.addAll(this.getOptionalAttributes(objClassName));
        return attributes;
    }

    public Collection getRequiredAttributes(String objClassName) throws UMSException {
        ArrayList attributeNames = new ArrayList();
        LDAPObjectClassSchema objClass = this.getLDAPSchema().getObjectClass(objClassName);
        if (objClass != null) {
            Enumeration en = objClass.getRequiredAttributes();
            while (en.hasMoreElements()) {
                attributeNames.add(en.nextElement());
            }
        }
        return attributeNames;
    }

    public Collection getOptionalAttributes(String objClassName) throws UMSException {
        ArrayList attributeNames = new ArrayList();
        LDAPObjectClassSchema objClass = this.getLDAPSchema().getObjectClass(objClassName);
        if (objClass != null) {
            Enumeration en = objClass.getOptionalAttributes();
            while (en.hasMoreElements()) {
                attributeNames.add(en.nextElement());
            }
        }
        return attributeNames;
    }

    public Collection getUniqueAttributes(String objClassName, Collection objClassNames) throws UMSException {
        Collection attributes = this.getAttributes(objClassName);
        ArrayList objClasses = (ArrayList)objClassNames;
        for (int i = 0; i < objClasses.size(); ++i) {
            attributes.removeAll(this.getAttributes((String)objClasses.get(i)));
        }
        return attributes;
    }

    public Collection getUniqueAttributes(String objClassName) throws UMSException {
        Collection attributes = this.getAttributes(objClassName);
        ArrayList attrs = new ArrayList(attributes);
        for (int i = 0; i < attrs.size(); ++i) {
            String attr = (String)attrs.get(i);
            if (this.getObjectClasses(attr).size() <= 1) continue;
            attributes.remove(attr);
        }
        return attributes;
    }

    private String getNameFromAttribute(String raw) {
        LDAPAttributeSchema attrType = new LDAPAttributeSchema(raw);
        return attrType.getName();
    }

    private String getNameFromObjectClass(String raw) {
        LDAPObjectClassSchema objClass = new LDAPObjectClassSchema(raw);
        return objClass.getName();
    }

    public void modifySchema(String file) throws UMSException {
        LDAPModification[] mods = null;
        try {
            LDIF ldif = new LDIF(file);
            LDIFRecord rec = ldif.nextRecord();
            while (rec != null) {
                LDIFContent content = rec.getContent();
                if (content instanceof LDIFModifyContent) {
                    mods = ((LDIFModifyContent)content).getModifications();
                    for (int i = 0; i < mods.length; ++i) {
                        LDAPAttribute attr = mods[i].getAttribute();
                        String attrTypeRawString = attr.getStringValueArray()[0];
                        String objClassRawString = attr.getStringValueArray()[0];
                        int operation = mods[i].getOp();
                        if (operation == 0) {
                            if (attr.getName().equalsIgnoreCase("attributetypes")) {
                                this.addAttribute(attrTypeRawString);
                                continue;
                            }
                            if (!attr.getName().equalsIgnoreCase("objectclasses")) continue;
                            this.addObjectClass(objClassRawString);
                            continue;
                        }
                        if (operation == 2) {
                            if (attr.getName().equalsIgnoreCase("attributetypes")) {
                                this.removeAttribute(this.getNameFromAttribute(attrTypeRawString));
                                this.addAttribute(attrTypeRawString);
                                continue;
                            }
                            if (!attr.getName().equalsIgnoreCase("objectclasses")) continue;
                            this.removeObjectClass(this.getNameFromObjectClass(objClassRawString));
                            this.addObjectClass(objClassRawString);
                            continue;
                        }
                        if (operation != 1) continue;
                        if (attr.getName().equalsIgnoreCase("attributetypes")) {
                            this.removeAttribute(this.getNameFromAttribute(attrTypeRawString));
                            continue;
                        }
                        if (!attr.getName().equalsIgnoreCase("objectclasses")) continue;
                        this.removeObjectClass(this.getNameFromObjectClass(objClassRawString));
                    }
                }
                rec = ldif.nextRecord();
            }
        }
        catch (IOException e) {
            String msg = i18n.getString("ums-readingldiffailed");
            throw new UMSException(msg, e);
        }
    }
}

