/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import netscape.ldap.LDAPDN;

class PCMappingTable
implements Serializable {
    private Principal _principal;
    private Guid _mappingGuid;
    private static final String[] ATTRNAMESTOSKIP = new String[]{"ou", "objectclass", "default"};
    private static final String MAPPINGTABLE_ENTRYNAME = "pcmappingtable";
    private static final String DEFAULT_PC_ATTRNAME = "default";

    protected PCMappingTable(Principal principal, Guid mappingGuid) throws UMSException {
        this._principal = principal;
        this._mappingGuid = mappingGuid;
    }

    public static PCMappingTable getPCMappingTable(Organization org) throws UMSException {
        PersistentObject po = null;
        SearchResults results = org.getChildren("ou=pcmappingtable", null);
        if (results.hasMoreElements()) {
            po = results.next();
        } else {
            po = new PersistentObject();
            po.setAttribute(new Attr("objectclass", new String[]{"top", "extensibleobject"}));
            po.setAttribute(new Attr("ou", MAPPINGTABLE_ENTRYNAME));
            Guid guid = new Guid("ou=pcmappingtable," + org.getGuid().getDn());
            po.setGuid(guid);
            org.addChild(po);
        }
        results.abandon();
        PCMappingTable mt = new PCMappingTable(org.getPrincipal(), po.getGuid());
        return mt;
    }

    public String getPeopleContainer(User user) throws UMSException {
        PersistentObject po = UMSObject.getObject(this._principal, this._mappingGuid);
        AttrSet attrSet = po.getAttrSet();
        String defaultPC = this.getDefault(attrSet);
        for (int j = 0; j < ATTRNAMESTOSKIP.length; ++j) {
            attrSet.remove(ATTRNAMESTOSKIP[j]);
        }
        Enumeration e1 = attrSet.getAttributes();
        while (e1.hasMoreElements()) {
            Attr attr = (Attr)e1.nextElement();
            String guid = attr.getName();
            String[] filters = attr.getStringValues();
            for (int j = 0; j < filters.length; ++j) {
                AttrSet filterAttrSet = this.getAttrSetFromFilter(filters[j]);
                Enumeration e2 = filterAttrSet.getAttributes();
                while (e2.hasMoreElements()) {
                    Attr filterAttr = (Attr)e2.nextElement();
                    Attr userAttr = user.getAttribute(filterAttr.getName());
                    if (userAttr == null) continue;
                    String[] filterAttrValues = filterAttr.getStringValues();
                    for (int i = 0; i < filterAttrValues.length; ++i) {
                        if (!userAttr.contains(filterAttrValues[i])) continue;
                        return guid;
                    }
                }
            }
        }
        return defaultPC;
    }

    public void addRule(Guid guid, String filter) throws UMSException {
        DataLayer.getInstance().addAttributeValue(this._principal, this._mappingGuid, LDAPDN.normalize((String)guid.getDn()), filter);
    }

    public void removeRule(Guid guid, String filter) throws UMSException {
        DataLayer.getInstance().removeAttributeValue(this._principal, this._mappingGuid, LDAPDN.normalize((String)guid.getDn()), filter);
    }

    public void setDefault(Guid guid) throws UMSException {
        DataLayer.getInstance().addAttributeValue(this._principal, this._mappingGuid, DEFAULT_PC_ATTRNAME, guid.getDn());
    }

    private String getDefault(AttrSet attrSet) {
        Attr attr = attrSet.getAttribute(DEFAULT_PC_ATTRNAME);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private AttrSet getAttrSetFromFilter(String filter) {
        AttrSet attrSet = new AttrSet();
        String f = new String(filter);
        f.trim();
        if (f.startsWith("(") && f.endsWith(")")) {
            f = f.substring(1, f.length() - 1);
        }
        if (f.startsWith("|") || f.startsWith("!")) {
            return null;
        }
        if (f.startsWith("&")) {
            int level = 0;
            int start = 0;
            int end = 0;
            for (int i = 0; i < f.length(); ++i) {
                int idx;
                if (f.charAt(i) == '(') {
                    if (level == 0) {
                        start = i;
                    }
                    ++level;
                }
                if (f.charAt(i) != ')' || --level != 0) continue;
                end = i;
                String subf = f.substring(start, end + 1);
                if (subf.startsWith("(") && subf.endsWith(")")) {
                    subf = subf.substring(1, subf.length() - 1);
                }
                if ((idx = subf.indexOf(61)) == -1) {
                    return null;
                }
                String type = subf.substring(0, idx).trim();
                String value = subf.substring(idx + 1).trim();
                attrSet.add(new Attr(type, value));
            }
        } else {
            int idx = f.indexOf(61);
            if (idx == -1) {
                return null;
            }
            String type = f.substring(0, idx).trim();
            String value = f.substring(idx + 1).trim();
            attrSet.add(new Attr(type, value));
        }
        return attrSet;
    }
}

