/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PCMappingTable;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.User;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;

public class Organization
extends PersistentObject {
    private static I18n i18n = I18n.getInstance("amSDK");
    private static final Class _class = Organization.class;

    protected Organization() throws UMSException {
    }

    Organization(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    Organization(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public Organization(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void addChild(PersistentObject object) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            String msg = i18n.getString("ums-bad-principal-hdl");
            throw new IllegalArgumentException(msg);
        }
        if (object == null) {
            String msg = i18n.getString("ums-badobjtoadd");
            throw new IllegalArgumentException(msg);
        }
        if (object instanceof User) {
            String pcId = this.getPeopleContainer((User)object);
            if (pcId != null) {
                PeopleContainer pc = new PeopleContainer(this.getPrincipal(), new Guid(pcId));
                pc.addUser((User)object);
            } else {
                super.addChild(object);
            }
        } else {
            super.addChild(object);
        }
    }

    public void removeChild(PersistentObject object) throws AccessRightsException, EntryNotFoundException, UMSException {
        if (object != null && this.getPrincipal() != null) {
            super.removeChild(object);
        }
    }

    public String getName() throws UMSException {
        return this.getAttribute(this.getNamingAttribute()).getValue();
    }

    public Collection getPeopleContainerGuids() throws UMSException {
        ArrayList<Guid> pcs = new ArrayList<Guid>();
        SearchTemplate template = TemplateManager.getTemplateManager().getSearchTemplate("BasicPeopleContainerSearch", this.getGuid());
        SearchResults results = this.search(template, null);
        while (results.hasMoreElements()) {
            pcs.add(results.next().getGuid());
        }
        return pcs;
    }

    private String getPeopleContainer(User user) throws UMSException {
        PCMappingTable mt = PCMappingTable.getPCMappingTable(this);
        return mt.getPeopleContainer(user);
    }

    public void addPeopleContainerRule(Guid guid, String filter) throws UMSException {
        PCMappingTable mt = PCMappingTable.getPCMappingTable(this);
        mt.addRule(guid, filter);
    }

    public void removePeopleContainerRule(Guid guid, String filter) throws UMSException {
        PCMappingTable mt = PCMappingTable.getPCMappingTable(this);
        mt.removeRule(guid, filter);
    }

    public void setDefaultPeopleContainer(Guid guid) throws UMSException {
        PCMappingTable mt = PCMappingTable.getPCMappingTable(this);
        mt.setDefault(guid);
    }
}

