/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import com.iplanet.ums.AccessRightObject;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.IRole;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;

public abstract class BaseRole
extends PersistentObject
implements IRole {
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private PersistentObject parentObject = null;
    private static final String READ_PERM_STRING = "read";
    private static final String READ_PERM_HEADER = "Read permission for ";
    private static final String WRITE_PERM_STRING = "write";
    private static final String WRITE_PERM_HEADER = "Write permission for ";

    protected BaseRole() {
    }

    BaseRole(Principal p, String guid) throws UMSException {
    }

    public BaseRole(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public boolean hasMember(PersistentObject po) throws UMSException {
        boolean hasTheMember = false;
        Attr attr = po.getAttribute("nsRole");
        if (attr != null && (attr.contains(this.getGuid().getDn()) || attr.contains(this.getGuid().getDn().toLowerCase()))) {
            hasTheMember = true;
        }
        return hasTheMember;
    }

    public AccessRightObject getAccessRight() throws UMSException, ACIParseException {
        Iterator acis;
        QualifiedCollection readPerm = null;
        QualifiedCollection writePerm = null;
        if (this.parentObject == null) {
            this.parentObject = this.getParentObject();
        }
        if ((acis = this.parentObject.getACI().iterator()) != null) {
            String guid = this.getGuid().getDn().trim();
            while (acis.hasNext()) {
                String aciName;
                ACI aci = (ACI)acis.next();
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.getAccessRight ACI.toString =" + aci.toString());
                }
                if ((aciName = aci.getName()).equalsIgnoreCase(READ_PERM_HEADER + guid)) {
                    readPerm = aci.getTargetAttributes();
                    if (writePerm == null) continue;
                    break;
                }
                if (!aciName.equalsIgnoreCase(WRITE_PERM_HEADER + guid)) continue;
                writePerm = aci.getTargetAttributes();
                if (readPerm == null) continue;
                break;
            }
        }
        if (readPerm == null) {
            if (writePerm == null) {
                return new AccessRightObject(null, null);
            }
            return new AccessRightObject(null, writePerm.getCollection());
        }
        if (writePerm == null) {
            return new AccessRightObject(readPerm.getCollection(), null);
        }
        return new AccessRightObject(readPerm.getCollection(), writePerm.getCollection());
    }

    public void newAccessRight(AccessRightObject accessRight) throws UMSException, ACIParseException {
        Attr attr;
        QualifiedCollection perm;
        HashSet<String> hs;
        Attr attr2;
        Iterator acis;
        ACI readACI = null;
        ACI writeACI = null;
        if (this.parentObject == null) {
            this.parentObject = this.getParentObject();
        }
        if ((acis = this.parentObject.getACI().iterator()) != null) {
            String guid = this.getGuid().getDn().trim();
            while (acis.hasNext()) {
                String aciName;
                ACI aci = (ACI)acis.next();
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.newAccessRight ACI.toString =" + aci.toString());
                }
                if ((aciName = aci.getName()).equals(READ_PERM_HEADER + guid)) {
                    readACI = aci;
                    if (writeACI == null) continue;
                    break;
                }
                if (!aciName.equals(WRITE_PERM_HEADER + guid)) continue;
                writeACI = aci;
                if (readACI == null) continue;
                break;
            }
        }
        if (readACI != null) {
            debug.message("modify existing read aci");
            attr2 = new Attr("aci", readACI.getACIText());
            if (debug.messageEnabled()) {
                debug.message("readaci.ACIText :" + readACI.getACIText());
            }
            this.parentObject.modify(attr2, 1);
            ACI newReadACI = ACI.valueOf(readACI.toString());
            QualifiedCollection readAttrs = new QualifiedCollection(accessRight.getReadableAttributeNames(), false);
            newReadACI.setTargetAttributes(readAttrs);
            attr2 = new Attr("aci", newReadACI.toString());
            this.parentObject.modify(attr2, 0);
        } else {
            debug.message("new read aci");
            ACI newReadACI = new ACI(READ_PERM_HEADER + this.getGuid().getDn());
            newReadACI.setName(READ_PERM_HEADER + this.getGuid().getDn());
            QualifiedCollection readAttrs = new QualifiedCollection(accessRight.getReadableAttributeNames(), false);
            newReadACI.setTargetAttributes(readAttrs);
            hs = new HashSet<String>();
            hs.add(READ_PERM_STRING);
            perm = new QualifiedCollection(hs, false);
            newReadACI.setPermissions(perm);
            hs = new HashSet();
            hs.add(this.getGuid().getDn());
            newReadACI.setRoles(hs);
            attr = new Attr("aci", newReadACI.toString());
            if (debug.messageEnabled()) {
                debug.message("READ " + this.getGuid().getDn() + "=" + newReadACI.toString());
            }
            this.parentObject.modify(attr, 0);
        }
        if (writeACI != null) {
            debug.message("modify existing write aci");
            attr2 = new Attr("aci", writeACI.getACIText());
            if (debug.messageEnabled()) {
                debug.message("writeaci.ACIText :" + writeACI.getACIText());
            }
            this.parentObject.modify(attr2, 1);
            ACI newWriteACI = ACI.valueOf(writeACI.toString());
            QualifiedCollection qual = new QualifiedCollection(accessRight.getWritableAttributeNames(), false);
            newWriteACI.setTargetAttributes(qual);
            attr2 = new Attr("aci", newWriteACI.toString());
            this.parentObject.modify(attr2, 0);
        } else {
            debug.message("new write aci");
            ACI newWriteACI = new ACI(WRITE_PERM_HEADER + this.getGuid().getDn());
            newWriteACI.setName(WRITE_PERM_HEADER + this.getGuid().getDn());
            QualifiedCollection writeAttrs = new QualifiedCollection(accessRight.getWritableAttributeNames(), false);
            newWriteACI.setTargetAttributes(writeAttrs);
            hs = new HashSet();
            hs.add(WRITE_PERM_STRING);
            perm = new QualifiedCollection(hs, false);
            newWriteACI.setPermissions(perm);
            hs = new HashSet();
            hs.add(this.getGuid().getDn());
            newWriteACI.setRoles(hs);
            attr = new Attr("aci", newWriteACI.toString());
            if (debug.messageEnabled()) {
                debug.message("Write " + this.getGuid().getDn() + "=" + newWriteACI.toString());
            }
            this.parentObject.modify(attr, 0);
        }
        this.parentObject.save();
    }
}

