/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.IDynamicMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.shared.debug.Debug;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class AssignableDynamicGroup
extends DynamicGroup
implements IAssignableMembership,
IDynamicMembership {
    private static I18n i18n = I18n.getInstance("amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String MEMBER_ATTR_NAME = "memberof";
    private static final Class _class = new AssignableDynamicGroup().getClass();

    public AssignableDynamicGroup() {
    }

    AssignableDynamicGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public AssignableDynamicGroup(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    AssignableDynamicGroup(AttrSet attrSet, Guid baseGuid, int scope) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet, baseGuid, scope);
    }

    public AssignableDynamicGroup(CreationTemplate template, AttrSet attrSet, Guid baseGuid, int scope) throws UMSException {
        super(template, attrSet);
        this.setUrl(baseGuid, null, scope);
    }

    public void setSearchFilter(String filter) {
        LDAPUrl url = this.getUrl();
        int scope = url.getScope();
        if (scope != 1 && scope != 2) {
            String msg = i18n.getString("ums-illegaladgroupscope");
            throw new IllegalArgumentException(msg);
        }
        Guid baseGuid = new Guid(url.getDN());
        this.setUrl(baseGuid, filter, scope);
    }

    protected void setGuid(Guid guid) {
        block2: {
            super.setGuid(guid);
            try {
                this.setSearchFilter("memberof=" + this.getDN());
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block2;
                debug.message("AssignableDynamicGroup.setGuid() : Exception : " + e.getMessage());
            }
        }
    }

    public void addMember(Guid userGuid) throws UMSException {
        if (this.getPrincipal() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-principal"));
        }
        this.addMember(UMSObject.getObject(this.getPrincipal(), userGuid));
    }

    public void addMember(PersistentObject member) throws UMSException {
        LDAPUrl memberUrl;
        DN memberDN;
        DN userDN = new DN(member.getGuid().getDn());
        if (!userDN.isDescendantOf(memberDN = new DN((memberUrl = this.getUrl()).getDN())) || userDN.equals(memberDN)) {
            Object[] args = new String[]{userDN.toString(), memberUrl.toString()};
            String msg = i18n.getString("ums-usernotingroupscope", args);
            throw new UMSException(msg);
        }
        if (userDN.countRDNs() - memberDN.countRDNs() > 1 && memberUrl.getScope() == 1) {
            Object[] args = new String[]{userDN.toString(), memberUrl.toString()};
            String msg = i18n.getString("ums-usernotingroupscope", args);
            throw new UMSException(msg);
        }
        member.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 0);
        member.save();
    }

    public void addMembers(Guid[] guids) throws UMSException {
        if (guids == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        for (int i = 0; i < guids.length; ++i) {
            this.addMember(guids[i]);
        }
    }

    public void removeMember(Guid guid) throws UMSException {
        PersistentObject member = UMSObject.getObject(this.getPrincipal(), guid);
        this.removeMember(member);
    }

    public void removeMember(PersistentObject member) throws UMSException {
        member.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 1);
        member.save();
    }

    public void removeAllMembers() throws UMSException {
        String filter = this.getSearchFilter();
        if (filter == null) {
            return;
        }
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(attributesToGet);
        while (searchResults.hasMoreElements()) {
            PersistentObject member = searchResults.next();
            member.setPrincipal(this.getPrincipal());
            this.removeMember(member);
        }
    }

    public boolean hasMember(Guid guid) throws UMSException {
        if (this.getPrincipal() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-principal"));
        }
        PersistentObject object = UMSObject.getObject(this.getPrincipal(), guid);
        Attr attr = object.getAttribute(MEMBER_ATTR_NAME);
        if (attr == null) {
            if (debug.messageEnabled()) {
                debug.message("AssignableDynamicGroup.hasMember: no attribute memberof in " + guid.getDn());
            }
            return false;
        }
        String normalized = this.getGuid().getDn();
        String[] members = attr.getStringValues();
        for (int i = 0; i < members.length; ++i) {
            String target = members[i];
            if (debug.messageEnabled()) {
                debug.message("AssignableDynamicGroup.hasMember: comparing " + normalized + " to " + target);
            }
            if (!Guid.equals(normalized, target)) continue;
            return true;
        }
        return false;
    }
}

