/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class SiteStatusCheckThreadImpl
implements WebtopNaming.SiteStatusCheck {
    protected static Debug debug = Debug.getInstance((String)"amNaming");
    private static int timeout = Long.valueOf(SystemProperties.get("com.sun.identity.sitemonitor.timeout", "10000")).intValue();
    private static final String hcPath = SystemProperties.get("com.sun.identity.urlchecker.targeturl", "/amserver/namingservice");
    private static int urlCheckerInvalidateInterval = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.invalidate.interval", "70000")).intValue();
    private static int urlCheckerSleep = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.sleep.interval", "30000")).intValue();
    private HashMap urlCheckers = new HashMap();

    private String getThreadName(URL u) {
        return "Site-Monitor " + u.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLChecker getURLChecker(URL url) {
        if (this.urlCheckers.get(this.getThreadName(url)) == null) {
            URLChecker checker = new URLChecker(this.getThreadName(url), url);
            HashMap hashMap = this.urlCheckers;
            synchronized (hashMap) {
                this.urlCheckers.put(this.getThreadName(url), checker);
            }
            checker.start();
            try {
                checker.join(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (URLChecker)this.urlCheckers.get(this.getThreadName(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCheckSiteStatus(URL url) {
        URLChecker checker = this.getURLChecker(url);
        if (!(checker == null || checker.isAlive() && checker.getStatus() != 0)) {
            checker.setTerminateThread(true);
            checker.interrupt();
            HashMap hashMap = this.urlCheckers;
            synchronized (hashMap) {
                this.urlCheckers.remove(this.getThreadName(url));
            }
            if (debug.messageEnabled()) {
                debug.message("SiteStatusCheckThreadImpl.doCheckSiteStatus() :Killing thread " + this.getThreadName(url));
            }
            return false;
        }
        return checker != null && checker.getStatus() == 1;
    }

    class URLChecker
    extends Thread {
        private URL url;
        private boolean terminateThread;
        private URLStatus urlStatus;

        URLChecker(String threadName, URL url) {
            super(threadName);
            this.url = null;
            this.terminateThread = false;
            this.urlStatus = null;
            this.url = this.getHealthCheckURL(url);
            this.setUrlStatus(new URLStatus());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (debug.messageEnabled()) {
                debug.message("URLChecker.run() : monitoring URL " + this.url.toExternalForm());
            }
            while (!this.isTerminateThread()) {
                try {
                    boolean sockStatus = this.checkSocketConnection(this.url);
                    if (!sockStatus) {
                        this.getUrlStatus().setStatus(-1);
                        continue;
                    }
                    Date t0 = null;
                    if (debug.messageEnabled()) {
                        t0 = Calendar.getInstance().getTime();
                    }
                    HttpURLConnection huc = HttpURLConnectionManager.getConnection((URL)this.url);
                    huc.setDoInput(true);
                    huc.setRequestMethod("GET");
                    String s = huc.getHeaderField(0);
                    if (debug.messageEnabled()) {
                        Date t1 = Calendar.getInstance().getTime();
                        long t = t1.getTime() - t0.getTime();
                        debug.message("URLChecker.run() : Http connection took " + t + " ms");
                    }
                    if (s != null) {
                        if (debug.messageEnabled()) {
                            debug.message("URLChecker.run() :  setting status to AVAILABLE for " + this.url.toExternalForm());
                        }
                        this.getUrlStatus().setStatus(1);
                    } else {
                        if (debug.messageEnabled()) {
                            debug.message("URLChecker.run() : setting status to ** UNAVAILABLE ** for " + this.url.toExternalForm());
                        }
                        this.getUrlStatus().setStatus(-1);
                    }
                    huc.disconnect();
                }
                catch (Exception e) {
                    debug.error("URLChecker.run() :  setting status to ** UNAVAILABLE ** for " + this.url.toExternalForm(), (Throwable)e);
                    this.getUrlStatus().setStatus(-1);
                }
                finally {
                    try {
                        Thread.sleep(urlCheckerSleep);
                    }
                    catch (InterruptedException e) {
                        debug.error("URLChecker.run() : Thread is interrupted " + this.url.toExternalForm(), (Throwable)e);
                    }
                }
            }
        }

        public boolean isTerminateThread() {
            return this.terminateThread;
        }

        public void setTerminateThread(boolean termineThread) {
            this.terminateThread = termineThread;
        }

        private URLStatus getUrlStatus() {
            return this.urlStatus;
        }

        private void setUrlStatus(URLStatus urlStatus) {
            this.urlStatus = urlStatus;
        }

        public int getStatus() {
            if (Calendar.getInstance().getTimeInMillis() - this.getUrlStatus().getLastStatusUpdatedTime().getTime() > (long)urlCheckerInvalidateInterval) {
                if (debug.messageEnabled()) {
                    debug.message("URLChecker.getStatus() : Last status update was @ " + this.getUrlStatus().getLastStatusUpdatedTime());
                }
                return 0;
            }
            return this.getUrlStatus().getStatus();
        }

        boolean checkSocketConnection(URL url) {
            boolean flag = false;
            try {
                InetSocketAddress inetsocketaddress = new InetSocketAddress(url.getHost(), url.getPort());
                Socket socket = new Socket();
                socket.connect(inetsocketaddress, timeout);
                socket.close();
                flag = true;
            }
            catch (IOException ioexception) {
                debug.error("URLChecker.checkSocketConnection() : Socket connection Failed : " + ioexception.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("URLChecker.checkSocketConnection() returning " + flag);
            }
            return flag;
        }

        private URL getHealthCheckURL(URL u) {
            URL url = null;
            int port = u.getPort();
            String protocol = u.getProtocol();
            if (port == -1) {
                port = protocol.equalsIgnoreCase("http") ? 80 : 443;
            }
            StringBuffer buff = new StringBuffer(protocol);
            buff.append("://").append(u.getHost()).append(":").append(port).append(hcPath);
            try {
                url = new URL(buff.toString());
            }
            catch (MalformedURLException e) {
                debug.error("URLChecker.getHealthCheckURL() : Incorrect URL : " + e.toString());
            }
            return url;
        }
    }

    class URLStatus {
        public static final int STATUS_UNKNOWN = 0;
        public static final int STATUS_AVAILABLE = 1;
        public static final int STATUS_UNAVAILABLE = -1;
        private int status = -1;
        private Date lastStatusUpdatedTime = null;

        public URLStatus() {
            this.setStatus(0);
            this.lastStatusUpdatedTime = Calendar.getInstance().getTime();
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
            if (this.getStatus() != 0) {
                this.lastStatusUpdatedTime = Calendar.getInstance().getTime();
            }
        }

        public Date getLastStatusUpdatedTime() {
            return this.lastStatusUpdatedTime;
        }
    }
}

