/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.util.Crypt;
import com.iplanet.services.util.GenericNode;
import com.iplanet.services.util.ParseOutput;
import com.iplanet.services.util.XMLParser;
import java.util.Hashtable;
import java.util.Vector;

public class LDAPUser
implements ParseOutput {
    public static final String ANONYMOUS_USER = "";
    public static final String ANONYMOUS_PASSWD = "";
    private String userID;
    private String userName;
    private Type userType = Type.AUTH_ANONYMOUS;
    private String userPasswd;

    public void process(XMLParser parser, String name, Vector elems, Hashtable atts, String Pcdata) {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in LDAPUser.process()");
        }
        this.userID = (String)atts.get("name");
        for (int i = 0; i < elems.size(); ++i) {
            String str;
            GenericNode genNode = (GenericNode)elems.elementAt(i);
            if (genNode._name.equals("DirDN")) {
                this.userName = genNode._pcdata;
            }
            this.userType = (str = (String)atts.get("type")) == null || str.equalsIgnoreCase("auth") ? Type.AUTH_BASIC : (str.equalsIgnoreCase("proxy") ? Type.AUTH_PROXY : (str.equalsIgnoreCase("rebind") ? Type.AUTH_REBIND : (str.equalsIgnoreCase("admin") ? Type.AUTH_ADMIN : Type.AUTH_ANONYMOUS)));
            if (!genNode._name.equals("DirPassword")) continue;
            this.userPasswd = genNode._pcdata;
        }
    }

    protected String getAuthID() {
        if (this.userName == null) {
            return "";
        }
        return this.userName;
    }

    protected String getPasswd() {
        if (this.userPasswd == null) {
            return "";
        }
        return Crypt.decode((String)this.userPasswd);
    }

    public Type getAuthType() {
        return this.userType;
    }

    public String getUserID() {
        return this.userID;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("UserID=");
        buf.append(this.userID);
        buf.append(" UserName=");
        buf.append(this.userName);
        buf.append(" authType=");
        buf.append(this.userType.toString());
        buf.append(" authPassword=");
        buf.append(this.userPasswd);
        return buf.toString();
    }

    public static class Type {
        int authType = -1;
        public static final Type AUTH_ANONYMOUS = new Type(0);
        public static final Type AUTH_BASIC = new Type(1);
        public static final Type AUTH_PROXY = new Type(2);
        public static final Type AUTH_REBIND = new Type(3);
        public static final Type AUTH_ADMIN = new Type(4);

        private Type(int type) {
            this.authType = type;
        }

        public boolean equals(Type type) {
            return this.authType == type.authType;
        }

        public String toString() {
            if (this.equals(AUTH_ANONYMOUS)) {
                return "ANONYMOUS";
            }
            if (this.equals(AUTH_BASIC)) {
                return "BASIC";
            }
            if (this.equals(AUTH_PROXY)) {
                return "PROXY";
            }
            if (this.equals(AUTH_REBIND)) {
                return "REBIND";
            }
            if (this.equals(AUTH_ADMIN)) {
                return "ADMIN";
            }
            return "ANONYMOUS";
        }
    }
}

