/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.IDSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.I18n;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLParser;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.shared.debug.Debug;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class DSConfigMgr
implements IDSConfigMgr {
    private static final String LDAP_CONNECTION_NUM_RETRIES = "com.iplanet.am.ldap.connection.num.retries";
    private static final String LDAP_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static final String RUN_TIME_CONFIG_PATH = "com.iplanet.coreservices.configpath";
    private int connNumRetry;
    private int connRetryInterval;
    private HashSet retryErrorCodes;
    static Debug debugger = null;
    Hashtable groupHash;
    public static final String ROOT = "iPlanetDataAccessLayer";
    public static final String SERVERGROUP = "ServerGroup";
    public static final String SERVER = "Server";
    public static final String USER = "User";
    public static final String SERVER_ID = "serverid";
    public static final String CERTIFICATE = "Certificate";
    public static final String AUTH_USER_ID = "authUser";
    public static final String AUTH_ID = "DirDN";
    public static final String AUTH_PASSWD = "DirPassword";
    public static final String AUTH_TYPE = "type";
    public static final String BASE_DN = "BaseDN";
    public static final String MISC_CONFIG = "MiscConfig";
    public static final String NAME = "name";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String MAX_CONN_POOL = "maxConnPool";
    public static final String MIN_CONN_POOL = "minConnPool";
    public static final String VALUE = "value";
    public static final String VAL_INACTIVE = "inactive";
    public static final String VAL_AUTH_BASIC = "auth";
    public static final String VAL_AUTH_PROXY = "proxy";
    public static final String VAL_AUTH_REBIND = "rebind";
    public static final String VAL_AUTH_ADMIN = "admin";
    public static final String VAL_AUTH_ANONYMOUS = "anonymous";
    public static final String VAL_STYPE_SSL = "SSL";
    public static final String VAL_STYPE_SIMPLE = "SIMPLE";
    public static final int DEF_INIT_CP_LEN = 1;
    public static final int DEF_MAX_CP_LEN = 1;
    static DSConfigMgr thisInstance;
    private static I18n i18n;
    public static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    public static final String VAL_STANDARD = "standard";
    public static final String INVALID_SERVER_ID = "InvalidServerID";
    public static final String SERVER_ID_DOES_NOT_EXIST = "ServerIDDoesNotExist";
    public static final String INVALID_USER_ID = "InvalidUserID";
    public static final String DEFAULT = "default";

    DSConfigMgr() {
        String retryErrs;
        block9: {
            String retryIntervalStr;
            block8: {
                this.connNumRetry = 3;
                this.connRetryInterval = 1000;
                this.retryErrorCodes = new HashSet();
                this.groupHash = null;
                i18n = I18n.getInstance("amSDK");
                this.groupHash = new Hashtable();
                String numRetryStr = SystemProperties.get(LDAP_CONNECTION_NUM_RETRIES);
                if (numRetryStr != null) {
                    try {
                        this.connNumRetry = Integer.parseInt(numRetryStr);
                    }
                    catch (NumberFormatException e) {
                        if (!debugger.warningEnabled()) break block8;
                        debugger.warning("Invalid value for com.iplanet.am.ldap.connection.num.retries");
                    }
                }
            }
            if ((retryIntervalStr = SystemProperties.get(LDAP_CONNECTION_RETRY_INTERVAL)) != null) {
                try {
                    this.connRetryInterval = Integer.parseInt(retryIntervalStr);
                }
                catch (NumberFormatException e) {
                    if (!debugger.warningEnabled()) break block9;
                    debugger.warning("Invalid value for com.iplanet.am.ldap.connection.delay.between.retries");
                }
            }
        }
        if ((retryErrs = SystemProperties.get(LDAP_CONNECTION_ERROR_CODES)) != null) {
            StringTokenizer stz = new StringTokenizer(retryErrs, ",");
            while (stz.hasMoreTokens()) {
                this.retryErrorCodes.add(stz.nextToken().trim());
            }
        }
    }

    public static synchronized DSConfigMgr getDSConfigMgr() throws LDAPServiceException {
        if (thisInstance == null) {
            FileInputStream is = null;
            try {
                String path = SystemProperties.get("com.iplanet.services.configpath");
                if (path == null) {
                    path = System.getProperty(RUN_TIME_CONFIG_PATH);
                }
                String configFile = path + System.getProperty("file.separator") + "serverconfig.xml";
                is = new FileInputStream(configFile);
            }
            catch (IOException ex) {
                if (debugger.warningEnabled()) {
                    debugger.warning("DSConfigMgr.getDSConfigMgr: serverconfig.xml probably missing. May be running in client mode  ", (Throwable)ex);
                }
                throw new LDAPServiceException(19, ex.getMessage());
            }
            thisInstance = new DSConfigMgr();
            thisInstance.loadServerConfiguration(is);
        }
        return thisInstance;
    }

    public static synchronized void initInstance(InputStream is) throws LDAPServiceException {
        thisInstance = new DSConfigMgr();
        thisInstance.loadServerConfiguration(is);
    }

    public ServerGroup getServerGroup(String serverGroupID) {
        return (ServerGroup)this.groupHash.get(serverGroupID);
    }

    public LDAPConnection getNewProxyConnection(String serverGroupID) throws LDAPServiceException {
        return this.getNewConnection(serverGroupID, LDAPUser.Type.AUTH_PROXY);
    }

    public LDAPConnection getNewProxyConnection() throws LDAPServiceException {
        return this.getNewProxyConnection(DEFAULT);
    }

    public LDAPConnection getNewBasicConnection(String serverGroupID) throws LDAPServiceException {
        return this.getNewConnection(serverGroupID, LDAPUser.Type.AUTH_BASIC);
    }

    public LDAPConnection getNewAdminConnection() throws LDAPServiceException {
        debugger.message("in DSConfigMgr.getNewAdminConnection()");
        String serverGroupID = DEFAULT;
        LDAPUser.Type type = LDAPUser.Type.AUTH_ADMIN;
        String hostName = this.getHostName(serverGroupID);
        if (hostName.length() == 0) {
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
        }
        if (debugger.messageEnabled()) {
            debugger.message("DSConfigMgr:getNewAdminConnection():Hostname =" + hostName);
        }
        ServerInstance sCfg = this.getServerInstance(serverGroupID, type);
        String authID = null;
        String passwd = null;
        authID = sCfg.getAuthID();
        passwd = (String)AccessController.doPrivileged(new ServerInstanceAction(sCfg));
        return this.getConnection(hostName, 389, sCfg.getConnectionType(), authID, passwd);
    }

    public LDAPConnection getNewBasicConnection() throws LDAPServiceException {
        return this.getNewBasicConnection(DEFAULT);
    }

    public LDAPConnection getNewConnection(String serverGroupID, LDAPUser.Type authType) throws LDAPServiceException {
        return this.getNewFailoverConnection(serverGroupID, authType);
    }

    public LDAPConnectionPool getAnonymousConnectionPool() throws LDAPServiceException {
        LDAPConnection anonymousConnection = this.getNewFailoverConnection(DEFAULT, LDAPUser.Type.AUTH_ANONYMOUS);
        try {
            LDAPConnectionPool pool;
            ServerInstance si = this.getServerInstance(DEFAULT, LDAPUser.Type.AUTH_ANONYMOUS);
            final LDAPConnectionPool finalPool = pool = new LDAPConnectionPool("DSConfigMgr", si.getMinConnections(), si.getMaxConnections(), anonymousConnection);
            ShutdownManager.getInstance().addShutdownListener(new ShutdownListener(){

                public void shutdown() {
                    if (finalPool != null) {
                        finalPool.destroy();
                    }
                }
            });
            return pool;
        }
        catch (LDAPException le) {
            if (debugger.messageEnabled()) {
                debugger.message("Failed to create anon conn pool" + (Object)((Object)le));
            }
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-connectFail"));
        }
    }

    public LDAPConnection getNewFailoverConnection(String serverGroupID, LDAPUser.Type type) throws LDAPServiceException {
        debugger.message("in DSConfigMgr.getNewFailoverConnection()");
        String hostName = this.getHostName(serverGroupID);
        if (hostName.length() == 0) {
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
        }
        if (debugger.messageEnabled()) {
            debugger.message("Hostname =" + hostName);
        }
        ServerInstance sCfg = this.getServerInstance(serverGroupID, type);
        String authID = null;
        String passwd = null;
        if (!type.equals(LDAPUser.Type.AUTH_ANONYMOUS)) {
            authID = sCfg.getAuthID();
            passwd = (String)AccessController.doPrivileged(new ServerInstanceAction(sCfg));
        }
        if (type.equals(LDAPUser.Type.AUTH_ANONYMOUS)) {
            return this.getConnection(hostName, 389, sCfg.getConnectionType(), authID, passwd);
        }
        return this.getPrimaryConnection(hostName, 389, sCfg.getConnectionType(), authID, passwd);
    }

    private LDAPConnection getPrimaryConnection(String hostName, int port, Server.Type type, String authID, String passwd) throws LDAPServiceException {
        LDAPConnection conn = null;
        if ((hostName = hostName.trim()).length() == 0) {
            throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
        }
        StringTokenizer st = new StringTokenizer(hostName);
        String hpName = null;
        LDAPServiceException exception = null;
        while (st.hasMoreElements() && conn == null) {
            hpName = st.nextToken();
            if (hpName == null || hpName.length() == 0) continue;
            if (debugger.messageEnabled()) {
                debugger.message("DSConfigMgr.getPrimaryConnection: host name & port number " + hpName);
            }
            if (hpName.trim().length() == 0) {
                throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
            }
            try {
                int idx = hpName.indexOf(58);
                if (idx != -1) {
                    String upHost = hpName.substring(0, idx);
                    int upPort = Integer.parseInt(hpName.substring(idx + 1));
                    conn = this.getConnection(upHost, upPort, type, authID, passwd);
                    exception = null;
                    continue;
                }
                throw new LDAPServiceException(DSConfigMgr.getString("dscfg-serverNotFound"));
            }
            catch (LDAPServiceException e) {
                exception = e;
            }
            catch (NumberFormatException e) {
                throw new LDAPServiceException(e.getMessage());
            }
        }
        if (exception != null) {
            String configTime = SystemProperties.get("installTime", "false");
            if (!configTime.equalsIgnoreCase("true")) {
                debugger.error("Connection to LDAP server threw exception:", exception);
            }
            throw exception;
        }
        return conn;
    }

    private LDAPConnection getConnection(String hostName, int port, Server.Type type, String authID, String passwd) throws LDAPServiceException {
        debugger.message("in DSConfigMgr.getConnection()");
        LDAPConnection conn = null;
        if (type == Server.Type.CONN_SSL) {
            try {
                conn = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
            }
            catch (Exception e) {
                debugger.error("getConnection.JSSSocketFactory", (Throwable)e);
                throw new LDAPServiceException(DSConfigMgr.getString("dscfg-jssSockFactoryFail"));
            }
        } else {
            conn = new LDAPConnection();
        }
        int retry = 0;
        while (retry <= this.connNumRetry) {
            if (debugger.messageEnabled()) {
                debugger.message("DSConfigMgr.getConnection retry: " + retry);
            }
            try {
                if (authID != null && passwd != null) {
                    conn.connect(3, hostName, port, authID, passwd);
                } else {
                    conn.setOption(17, (Object)new Integer(3));
                    conn.connect(hostName, port);
                }
                conn.setOption(3, (Object)new Integer(0));
                break;
            }
            catch (LDAPException e) {
                if (!this.retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == this.connNumRetry) {
                    if (debugger.warningEnabled()) {
                        debugger.warning("Connection to LDAP server threw exception:", (Throwable)e);
                    }
                    throw new LDAPServiceException(DSConfigMgr.getString("dscfg-connectFail"), e);
                }
                ++retry;
                try {
                    Thread.sleep(this.connRetryInterval);
                }
                catch (InterruptedException ex) {}
            }
        }
        return conn;
    }

    public String getHostName(String serverGroupID) {
        ServerGroup serverGrp = this.getServerGroup(serverGroupID);
        Collection serverList = serverGrp.getServersList();
        StringBuffer hostName = new StringBuffer();
        Iterator serverIterator = serverList.iterator();
        while (serverIterator.hasNext()) {
            Server serverObj = (Server)serverIterator.next();
            hostName.append(serverObj.getServerName());
            hostName.append(':');
            hostName.append(serverObj.getPort());
            hostName.append(' ');
        }
        hostName.deleteCharAt(hostName.length() - 1);
        return hostName.toString();
    }

    public ServerInstance getServerInstance(String serverGroupID, LDAPUser.Type authType) {
        if (serverGroupID == null) {
            return null;
        }
        ServerGroup svc = this.getServerGroup(serverGroupID);
        if (svc != null) {
            return svc.getServerInstance(authType);
        }
        return null;
    }

    public ServerInstance getServerInstance(LDAPUser.Type authType) {
        return this.getServerInstance(DEFAULT, authType);
    }

    private void loadServerConfiguration(InputStream is) throws LDAPServiceException {
        XMLParser parser = new XMLParser(true, this.groupHash);
        parser.register(SERVERGROUP, "com.iplanet.services.ldap.ServerGroup");
        parser.register(SERVER, "com.iplanet.services.ldap.Server");
        parser.register(USER, "com.iplanet.services.ldap.LDAPUser");
        try {
            parser.parse(is);
        }
        catch (XMLException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            throw new LDAPServiceException(19, e.getMessage());
        }
    }

    public String toString() {
        return this.groupHash.toString();
    }

    static String getString(String keyword) {
        return i18n.getString(keyword);
    }

    static {
        debugger = Debug.getInstance((String)"amSDK");
        thisInstance = null;
        i18n = null;
    }
}

