/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.naming.service.NamingService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PLLRequestServlet
extends HttpServlet {
    private static Hashtable requestHandlers = new Hashtable();
    private static final String PROPERTY_MAX_CONTENT_LENGTH = "com.iplanet.services.comm.server.pllrequest.maxContentLength";
    private static int maxContentLength = 16384;
    private static final String AUTH_SVC_ID = "Auth";

    public void init() throws ServletException {
        block2: {
            String maxContentLengthProp = SystemProperties.get(PROPERTY_MAX_CONTENT_LENGTH, String.valueOf(maxContentLength));
            try {
                maxContentLength = Integer.parseInt(maxContentLengthProp);
            }
            catch (NumberFormatException e) {
                if (!PLLServer.pllDebug.messageEnabled()) break block2;
                PLLServer.pllDebug.message("Invalid value [" + maxContentLengthProp + "] for property" + PROPERTY_MAX_CONTENT_LENGTH);
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int length = req.getContentLength();
        if (length == -1) {
            throw new ServletException(PLLBundle.getString("unknownLength"));
        }
        if (length > maxContentLength) {
            if (PLLServer.pllDebug.messageEnabled()) {
                PLLServer.pllDebug.message("content length too large" + length);
            }
            throw new ServletException(PLLBundle.getString("largeContentLength"));
        }
        byte[] reqData = new byte[length];
        ServletInputStream in = req.getInputStream();
        int rlength = 0;
        int offset = 0;
        while (rlength != length) {
            int r = in.read(reqData, offset, length - offset);
            if (r == -1) {
                throw new ServletException(PLLBundle.getString("readRequestError"));
            }
            rlength += r;
            offset += r;
        }
        String xml = new String(reqData, 0, length, "UTF-8");
        RequestSet set = RequestSet.parseXML(xml);
        String svcid = set.getServiceID();
        if (!AUTH_SVC_ID.equalsIgnoreCase(svcid) && PLLServer.pllDebug.messageEnabled()) {
            PLLServer.pllDebug.message("\nReceived RequestSet XML :\n" + xml);
        }
        String responseXML = this.handleRequest(set, req, res);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF-8");
        try {
            out.write(responseXML);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
        if (PLLServer.pllDebug.messageEnabled()) {
            PLLServer.pllDebug.message("\nSent ResponseSet XML : " + responseXML);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        out.print("Sun Java System Federated Access Manager");
        out.flush();
    }

    private String handleRequest(RequestSet set, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        if (!this.isValid(set)) {
            throw new ServletException(PLLBundle.getString("invalidRequestSet"));
        }
        String svcid = set.getServiceID();
        RequestHandler handler = this.getServiceHandler(svcid);
        if (handler == null) {
            throw new ServletException(PLLBundle.getString("noRequestHandler"));
        }
        ResponseSet rset = handler.process(set.getRequests(), req, res, this.getServletConfig().getServletContext());
        rset.setRequestSetID(set.getRequestSetID());
        return rset.toXMLString();
    }

    private boolean isValid(RequestSet set) {
        return set != null && set.getRequestSetVersion() != null && set.getServiceID() != null && set.getRequestSetID() != null && set.getRequests().size() >= 1;
    }

    private RequestHandler getServiceHandler(String svcid) {
        RequestHandler handler = (RequestHandler)requestHandlers.get(svcid);
        if (handler == null) {
            try {
                if (svcid.equals("com.iplanet.am.naming")) {
                    handler = new NamingService();
                } else {
                    String svcclass = WebtopNaming.getServiceClass(svcid);
                    if (svcclass != null) {
                        Class<?> cl = Class.forName(svcclass);
                        handler = (RequestHandler)cl.newInstance();
                    } else if (PLLServer.pllDebug.messageEnabled()) {
                        PLLServer.pllDebug.message("Service handler for :" + svcid + " not found");
                    }
                }
                if (handler != null) {
                    requestHandlers.put(svcid, handler);
                }
            }
            catch (Exception e) {
                PLLServer.pllDebug.message("Cannot get service handler for " + svcid + " :", (Throwable)e);
                return null;
            }
        }
        return handler;
    }
}

