/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.Handler;
import com.iplanet.services.comm.https.HttpsClient;
import java.io.IOException;
import java.net.URL;
import org.mozilla.jss.crypto.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;

public class HttpsURLConnection
extends HttpURLConnection {
    private String nickName;

    protected void setNewClient(URL url) throws IOException {
        this.http = this.getNewClient(url);
    }

    protected HttpClient getNewClient(URL url) throws IOException {
        HttpsClient client = new HttpsClient(url);
        if (this.nickName != null) {
            client.setClientCertificate(this.nickName);
        }
        return client;
    }

    protected HttpClient getProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        throw new IOException("HTTPS proxying not supported");
    }

    HttpsURLConnection(URL url, Handler handler) throws IOException {
        super(url, handler);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if ("https".equals(this.url.getProtocol())) {
            this.http = HttpsClient.New(this.url);
            if (this.nickName != null) {
                ((HttpsClient)this.http).setClientCertificate(this.nickName);
            }
            this.connected = true;
        } else {
            super.connect();
        }
    }

    public String getCipherSuite() {
        return ((HttpsClient)this.http).getCipherSuite();
    }

    public X509Certificate[] getServerCertificateChain() {
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    public void setClientCertificate(String name) {
        this.nickName = name;
    }
}

