/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.services.cdm.ICDMConstants;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class Client
extends Observable
implements ICDMConstants {
    private static final String ADD_PROP_ATTR = AMClientCapData.ADDITIONAL_PROPERTIES_ATTR;
    private static final String SEPARATOR = "=";
    private static G11NSettings g11nSettings = G11NSettings.getInstance();
    private static Debug debug = Debug.getInstance((String)"amClientDetection");
    private String cType = null;
    private HashMap profileMap = null;
    private Set additionalProperties = null;

    public Client() {
    }

    public Client(String clientType, Map data) {
        this.profileMap = new HashMap(data.size());
        this.profileMap.putAll(data);
        this.cType = clientType;
        this.additionalProperties = this.separateAdditionalProperties(this.profileMap);
    }

    public static Client getInstance(String clientType) throws ClientException {
        return ClientsManager.getInstance(clientType);
    }

    protected static Client getInstance(String clientType, SSOToken token) throws ClientException {
        return Client.getInstance(clientType);
    }

    public static Client getDefaultInstance() {
        return ClientsManager.getDefaultInstance();
    }

    public static Iterator getAllInstances() {
        return ClientsManager.getAllInstances();
    }

    protected static Iterator getAllInstances(SSOToken token) {
        return Client.getAllInstances();
    }

    public String getClientType() {
        return this.cType;
    }

    public String getProperty(String name) {
        String value = null;
        Set properties = null;
        properties = this.getPropertiesInternal(name);
        if (properties != null) {
            Iterator iter = properties.iterator();
            value = (String)iter.next();
        }
        return value;
    }

    private Set getPropertiesInternal(String attributeName) {
        Set properties = (Set)this.profileMap.get(attributeName);
        return properties;
    }

    public Set getProperties(String name) {
        Set properties = this.getPropertiesInternal(name);
        Set umSet = null;
        if (properties != null) {
            umSet = Collections.unmodifiableSet(properties);
        }
        return umSet;
    }

    public Set getPropertyNames() {
        Set keys = this.profileMap.keySet();
        return keys;
    }

    public String getCharset(Locale loc) {
        try {
            return g11nSettings.getCharset(this.cType, loc);
        }
        catch (ClientException ex) {
            debug.error("Client.getCharset ", (Throwable)ex);
            return "ISO-8859-1";
        }
    }

    public Set getAdditionalProperties() {
        return this.additionalProperties;
    }

    protected Set separateAdditionalProperties(Map m) {
        Set addProps = null;
        if (m != null && (addProps = (Set)m.get(ADD_PROP_ATTR)) != null && addProps.size() > 0) {
            m.remove(ADD_PROP_ATTR);
            Iterator itr = addProps.iterator();
            while (itr.hasNext()) {
                String property = (String)itr.next();
                int index = property.indexOf(SEPARATOR);
                if (index <= 0) continue;
                String name = property.substring(0, index);
                String val = property.substring(index + 1);
                HashSet<String> set = new HashSet<String>(1);
                set.add(val);
                m.put(name, set);
            }
        }
        return addProps;
    }
}

