/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.shared.encode.CookieUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class GetHttpSession
extends HttpServlet {
    public static final String OP = "op";
    public static final String NO_OP = "";
    public static final String CREATE_OP = "create";
    public static final String RECOVER_OP = "recover";
    public static final String SAVE_OP = "save";
    public static final String INVALIDATE_OP = "invalidate";
    public static final String RELEASE_OP = "release";
    public static final String GET_RESTRICTED_TOKEN_OP = "get_restricted_token";
    public static final String DOMAIN = "domain";
    private static final long MAX_TIMESTAMP_DIFF = 600000L;

    private boolean validateRequest(HttpServletRequest servletRequest) {
        try {
            String encryptedCookie = CookieUtils.getCookieValueFromReq((HttpServletRequest)servletRequest, (String)"DSAMESecurityCookie");
            if (encryptedCookie == null) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: no Security Cookie in the request");
                return false;
            }
            String decryptedCookie = (String)AccessController.doPrivileged(new DecodeAction(encryptedCookie));
            StringTokenizer st = new StringTokenizer(decryptedCookie, "@");
            String serverURL = st.nextToken();
            long requestTimeStamp = Long.parseLong(st.nextToken());
            long currentTime = System.currentTimeMillis();
            if (Math.abs(currentTime - requestTimeStamp) > 600000L) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: Max time elapsed for the Request");
                return false;
            }
            Vector platformServerList = WebtopNaming.getPlatformServerList();
            if (!platformServerList.contains(serverURL)) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: request host :" + serverURL + "was not part of the platformServerList");
            }
            return true;
        }
        catch (Exception e) {
            SessionService.sessionDebug.error("GetHttpSession.validateRequest: Exception while validating the request ", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.validateRequest(request)) {
            response.setStatus(403);
            return;
        }
        String op = request.getParameter(OP);
        if (op.equals(RECOVER_OP)) {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                SessionID sid;
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.recover: Old HttpSession is obtained");
                }
                if ((sid = new SessionID(request)).isNull()) return;
                SessionService.getSessionService().retrieveSession(sid, httpSession);
                return;
            } else {
                SessionService.sessionDebug.error("GetHttpSession.recover: Old  HttpSession is not obtained");
            }
            return;
        }
        if (op.equals(SAVE_OP)) {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                SessionID sid;
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.save: HttpSession is obtained");
                }
                if ((sid = new SessionID(request)).isNull()) return;
                int status = SessionService.getSessionService().handleSaveSession(sid, httpSession);
                response.setStatus(status);
                return;
            } else {
                SessionService.sessionDebug.error("GetHttpSession.save: HttpSession is not obtained");
                response.setStatus(404);
            }
            return;
        }
        if (op.equals(CREATE_OP)) {
            HttpSession httpSession = request.getSession(true);
            String domain = request.getParameter(DOMAIN);
            InternalSession is = SessionService.getSessionService().newInternalSession(domain, httpSession);
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.create: Created new session=" + is.getID());
            }
            DataOutputStream out = new DataOutputStream((OutputStream)response.getOutputStream());
            out.writeUTF(is.getID().toString());
            out.flush();
            out.close();
            return;
        }
        if (op.equals(INVALIDATE_OP)) {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.invalidate: HttpSession is obtained");
                }
                try {
                    httpSession.invalidate();
                    return;
                }
                catch (IllegalStateException ise) {
                    if (!SessionService.sessionDebug.messageEnabled()) return;
                    SessionService.sessionDebug.message("Exception:invalidateSession: the web containers session timeout could be shorter than the Access Manager session timeout", (Throwable)ise);
                }
                return;
            } else {
                if (!SessionService.sessionDebug.warningEnabled()) return;
                SessionService.sessionDebug.warning("GetHttpSession.invalidate: session is not obtained");
            }
            return;
        }
        if (op.equals(RELEASE_OP)) {
            SessionID sid = new SessionID(request);
            if (!sid.isNull()) {
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.release: releasing session=" + sid);
                }
                int status = SessionService.getSessionService().handleReleaseSession(sid);
                response.setStatus(status);
                return;
            } else {
                if (!SessionService.sessionDebug.messageEnabled()) return;
                SessionService.sessionDebug.message("GetHttpSession.release: missing session id");
            }
            return;
        }
        if (op.equals(GET_RESTRICTED_TOKEN_OP)) {
            DataOutputStream out;
            DataInputStream in;
            block28: {
                in = null;
                out = null;
                SessionID sid = new SessionID(request);
                try {
                    in = new DataInputStream((InputStream)request.getInputStream());
                    TokenRestriction restriction = TokenRestrictionFactory.unmarshal(in.readUTF());
                    String token = SessionService.getSessionService().handleGetRestrictedTokenIdRemotely(sid, restriction);
                    if (token != null) {
                        if (SessionService.sessionDebug.messageEnabled()) {
                            SessionService.sessionDebug.message("GetHttpSession.get_restricted_token: Created new session=" + token);
                        }
                        response.setStatus(200);
                        out = new DataOutputStream((OutputStream)response.getOutputStream());
                        out.writeUTF(token);
                        out.flush();
                        break block28;
                    }
                    SessionService.sessionDebug.error("GetHttpSession.get_restricted_token: failed to create token");
                    response.setStatus(404);
                }
                catch (Exception ex) {
                    try {
                        SessionService.sessionDebug.error("GetHttpSession.get_restricted_token: exception occured while create token", (Throwable)ex);
                        response.setStatus(404);
                    }
                    catch (Throwable throwable) {
                        SessionService.closeStream(in);
                        SessionService.closeStream(out);
                        throw throwable;
                    }
                    SessionService.closeStream(in);
                    SessionService.closeStream(out);
                    return;
                }
            }
            SessionService.closeStream(in);
            SessionService.closeStream(out);
            return;
        }
        SessionService.sessionDebug.error("GetHttpSession: unknown operation requested");
        response.setStatus(501);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }
}

