/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.ha.FAMPersisterManager;
import com.sun.identity.ha.FAMRecord;
import com.sun.identity.ha.FAMRecordPersister;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.shared.debug.Debug;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.IllegalStateException;

public class JMQSessionRepository
extends GeneralTaskRunnable
implements AMSessionRepository {
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String DELETE = "DELETE";
    public static final String DELETEBYDATE = "DELETEBYDATE";
    public static final String SESSION = "session";
    public static final String ID = "ID";
    private static boolean isDatabaseUp = true;
    private static long gracePeriod = 300L;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static final String BRIEF_DB_ERROR_MSG = "Session failover service is not functional due to DB unavailability.";
    private static final String DB_ERROR_MSG = "Session database is not available at this moment.Please check with the system administrator for appropriate actions";
    private static final String LOG_MSG_DB_BACK_ONLINE = "SESSION_DATABASE_BACK_ONLINE";
    private static final String LOG_MSG_DB_UNAVAILABLE = "SESSION_DATABASE_UNAVAILABLE";
    private static boolean lastLoggedDBStatusIsUp = true;
    private static long cleanUpPeriod = 300000L;
    private static long cleanUpValue = 0L;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.session.repository.cleanupRunPeriod";
    private static long healthCheckPeriod = 60000L;
    public static final String HEALTH_CHECK_RUN_PERIOD = "com.sun.identity.session.repository.healthCheckRunPeriod";
    private static long runPeriod = 60000L;
    static Debug debug = SessionService.sessionDebug;
    public FAMRecordPersister pSession = null;

    public JMQSessionRepository() throws Exception {
        this.initPersistSession();
        SystemTimer.getTimer().schedule((TaskRunnable)this, new Date(System.currentTimeMillis() / 1000L * 1000L));
    }

    private void initPersistSession() {
        block2: {
            try {
                FAMPersisterManager.getInstance();
                this.pSession = FAMPersisterManager.getFAMRecordPersister();
                isDatabaseUp = true;
            }
            catch (Exception e) {
                isDatabaseUp = false;
                debug.error(BRIEF_DB_ERROR_MSG);
                if (!debug.messageEnabled()) break block2;
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
    }

    public InternalSession retrieve(SessionID sid) throws Exception {
        if (!isDatabaseUp) {
            return null;
        }
        try {
            String key = SessionUtils.getEncryptedStorageKey(sid);
            FAMRecord famRec = new FAMRecord(SESSION, READ, key, 0L, null, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
            byte[] blob = retRec.getBlob();
            InternalSession is = (InternalSession)SessionUtils.decode(blob);
            return is;
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            debug.message("JMQSessionRepository.retrieve(): failed retrieving session", (Throwable)e);
            return null;
        }
    }

    public void delete(SessionID sid) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            String key = SessionUtils.getEncryptedStorageKey(sid);
            FAMRecord famRec = new FAMRecord(SESSION, DELETE, key, 0L, null, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSessionRepository.delete(): failed deleting session", (Throwable)e);
        }
    }

    public void deleteExpired() throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            long date = System.currentTimeMillis() / 1000L;
            FAMRecord famRec = new FAMRecord(SESSION, DELETEBYDATE, null, date, null, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSessionRepository.deleteExpired(): failed deleting Expired Sessions", (Throwable)e);
        }
    }

    public void save(InternalSession is) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        try {
            SessionID sid = is.getID();
            String key = SessionUtils.getEncryptedStorageKey(sid);
            byte[] blob = SessionUtils.encode(is);
            long expirationTime = is.getExpirationTime() + gracePeriod;
            String uuid = is.getUUID();
            FAMRecord famRec = new FAMRecord(SESSION, WRITE, key, expirationTime, uuid, is.getState(), sid.toString(), blob);
            FAMRecord retRec = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSessionRepository.save(): failed to save Session", (Throwable)e);
        }
    }

    public Map getSessionsByUUID(String uuid) throws Exception {
        if (!isDatabaseUp) {
            throw new SessionException("Session repository is not available.");
        }
        HashMap sessions = null;
        try {
            FAMRecord famRec = new FAMRecord(SESSION, "GET_RECORD_COUNT", null, 0L, uuid, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
            sessions = retRec.getExtraStringAttributes();
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
            throw new SessionException(e);
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
        return sessions;
    }

    private void logDBStatus() {
        SessionService ss = SessionService.getSessionService();
        if (!isDatabaseUp && lastLoggedDBStatusIsUp) {
            ss.logSystemMessage(LOG_MSG_DB_UNAVAILABLE, Level.WARNING);
            lastLoggedDBStatusIsUp = false;
        }
        if (isDatabaseUp && !lastLoggedDBStatusIsUp) {
            ss.logSystemMessage(LOG_MSG_DB_BACK_ONLINE, Level.INFO);
            lastLoggedDBStatusIsUp = true;
        }
    }

    public long getRunPeriod() {
        return runPeriod;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    public void run() {
        try {
            if (debug.messageEnabled()) {
                debug.message("Cleaning expired session records");
            }
            if (cleanUpValue <= 0L) {
                this.deleteExpired();
                cleanUpValue = cleanUpPeriod;
            }
            cleanUpValue -= runPeriod;
            if (!isDatabaseUp) {
                this.initPersistSession();
                this.logDBStatus();
            }
        }
        catch (Exception e) {
            debug.error("JMQSessionRepository.run(): Exception in thread", (Throwable)e);
        }
    }

    static {
        try {
            gracePeriod = Integer.parseInt(SystemProperties.get(CLEANUP_GRACE_PERIOD, String.valueOf(gracePeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        try {
            cleanUpPeriod = Integer.parseInt(SystemProperties.get(CLEANUP_RUN_PERIOD, String.valueOf(cleanUpPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupRunPeriod, using default");
        }
        try {
            healthCheckPeriod = Integer.parseInt(SystemProperties.get(HEALTH_CHECK_RUN_PERIOD, String.valueOf(healthCheckPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.healthCheckRunPeriod, using default");
        }
        runPeriod = cleanUpPeriod <= healthCheckPeriod ? cleanUpPeriod : healthCheckPeriod;
        cleanUpValue = cleanUpPeriod;
    }
}

