/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.parser;

import com.iplanet.dpro.parser.GenericNode;
import com.iplanet.dpro.parser.ParseOutput;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebtopParser {
    private Hashtable elemmap = new Hashtable();
    private boolean useGenericClass = false;

    public static void main(String[] argv) throws Exception {
        WebtopParser wp = new WebtopParser(true);
        GenericNode n = (GenericNode)wp.parse(new FileInputStream(argv[0]));
        System.out.println("FINAL:" + n.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ParseOutput walkTree(Node nd) throws Exception {
        ParseOutput po;
        Vector<ParseOutput> elements = new Vector<ParseOutput>();
        String pcdata = null;
        Hashtable<String, String> atts = new Hashtable<String, String>();
        NamedNodeMap nd_map = nd.getAttributes();
        if (nd_map != null) {
            for (int i = 0; i < nd_map.getLength(); ++i) {
                Node att = nd_map.item(i);
                atts.put(att.getNodeName(), att.getNodeValue());
            }
        }
        block7: for (Node ch = nd.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            switch (ch.getNodeType()) {
                case 1: {
                    elements.addElement(this.walkTree(ch));
                    continue block7;
                }
                case 3: {
                    String tmp = this.stripWhitespaces(ch.getNodeValue());
                    if (tmp == null || tmp.length() == 0) continue block7;
                    pcdata = tmp;
                    continue block7;
                }
            }
        }
        String po_name = (String)this.elemmap.get(nd.getNodeName());
        if (po_name == null) {
            if (!this.useGenericClass) throw new Exception("No class registered for" + nd.getNodeName());
            po = new GenericNode();
        } else {
            try {
                po = (ParseOutput)Class.forName(po_name).newInstance();
            }
            catch (Exception ex) {
                StringBuffer buf = new StringBuffer();
                buf.append("Got Exception while creating class instance of ");
                buf.append(nd.getNodeName());
                buf.append(" :");
                buf.append(ex.toString());
                throw new Exception(buf.toString());
            }
        }
        po.process(nd.getNodeName(), elements, atts, pcdata);
        return po;
    }

    String stripWhitespaces(String s) {
        return s.trim();
    }

    public WebtopParser() {
    }

    public WebtopParser(boolean usegeneric) {
        this.useGenericClass = usegeneric;
    }

    public Object parse(String s) throws Exception {
        ByteArrayInputStream bin = null;
        String st = this.stripWhitespaces(s);
        try {
            bin = new ByteArrayInputStream(st.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Exception("Encoding not supported:" + ex.toString());
        }
        return this.parse(bin);
    }

    public Object parse(InputStream xmlin) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Exception("DBG:Got ParserConfigurationException:" + e.toString());
        }
        Document doc = null;
        try {
            doc = db.parse(xmlin);
        }
        catch (SAXParseException e) {
            throw new Exception("DBG:Got SAXParseException:" + e.toString() + "line:" + e.getLineNumber() + " col :" + e.getColumnNumber());
        }
        catch (SAXException e) {
            throw new Exception("DBG:Got SAXException:" + e.toString());
        }
        catch (IOException ex) {
            throw new Exception("DBG: Got IOException:" + ex.toString());
        }
        Element elem = doc.getDocumentElement();
        return this.walkTree(elem);
    }

    public void register(String elemname, String classname) {
        if (this.elemmap == null) {
            this.elemmap = new Hashtable();
        }
        this.elemmap.put(elemname, classname);
    }
}

