/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Misc;
import com.iplanet.services.cdm.ClientDetectionInterface;
import com.iplanet.services.cdm.ClientTypesManager;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AMClientDetector {
    private static ClientTypesManager clientManager;
    private static Map attrs;
    private static boolean detectionEnabled;
    private ClientDetectionInterface clientDetector;
    private static ClientDetectionInterface defaultClientDetector;
    private static final String CDM_SERVICE_NAME = "iPlanetAMClientDetection";
    private static final String CDM_CLASS_NAME = "iplanet-am-client-detection-class";
    private static final String CLIENT_TYPES_MANAGER_CLASS_NAME = "iplanet-am-client-types-manager-class";
    private static final String CDM_ENABLED_ATTR = "iplanet-am-client-detection-enabled";
    private static Debug debug;
    private static String ClientTypesManagerImpl;
    private static String clientDetectionClass;
    private static boolean servicePassed;

    public AMClientDetector() {
        this.clientDetector = defaultClientDetector;
    }

    public AMClientDetector(String className) {
        if (className != null) {
            try {
                this.clientDetector = (ClientDetectionInterface)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                this.clientDetector = defaultClientDetector;
            }
        } else {
            this.clientDetector = defaultClientDetector;
        }
    }

    public AMClientDetector(ClientDetectionInterface cd) {
        this.clientDetector = cd;
    }

    public String getClientType(HttpServletRequest request) {
        String clientType = null;
        debug.message("AMClientDetector.getClientType()");
        if (detectionEnabled) {
            try {
                if (this.clientDetector != null) {
                    clientType = this.clientDetector.getClientType(request);
                }
                if (debug.messageEnabled()) {
                    debug.message("AMClientDetector: Client Type : " + clientType);
                }
            }
            catch (Exception ex) {
                clientType = clientManager.getDefaultClientType();
            }
        }
        if (clientType == null || clientType.length() == 0) {
            clientType = "genericHTML";
        }
        if (debug.messageEnabled()) {
            debug.message("AMClientDetector: Default Client Type : " + clientType);
        }
        return clientType;
    }

    public String detectionEnabled() {
        return detectionEnabled ? "true" : "false";
    }

    public static ClientTypesManager getClientTypesManagerInstance() {
        return clientManager;
    }

    private static void initClientTypesManager() {
        if (ClientTypesManagerImpl != null && ClientTypesManagerImpl.length() > 0) {
            try {
                clientManager = (ClientTypesManager)Class.forName(ClientTypesManagerImpl).newInstance();
            }
            catch (Exception ex) {
                clientManager = new DefaultClientTypesManager();
            }
        } else {
            clientManager = new DefaultClientTypesManager();
        }
        clientManager.initManager();
    }

    private static void getServiceSchemaManager() {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager ssm = new ServiceSchemaManager(CDM_SERVICE_NAME, adminToken);
            ServiceSchema gsc = ssm.getGlobalSchema();
            attrs = gsc.getAttributeDefaults();
        }
        catch (Exception e) {
            debug.error("AMClientDetector.static: ", (Throwable)e);
            servicePassed = false;
            return;
        }
    }

    private static void getClientAttributes() {
        if (attrs != null) {
            String det = Misc.getMapAttr(attrs, CDM_ENABLED_ATTR);
            detectionEnabled = det != null && det.equalsIgnoreCase("true");
            if (debug.messageEnabled()) {
                debug.message("AMClientDetector: ClientDetection enable : " + detectionEnabled);
            }
            clientDetectionClass = Misc.getMapAttr(attrs, CDM_CLASS_NAME);
            ClientTypesManagerImpl = Misc.getMapAttr(attrs, CLIENT_TYPES_MANAGER_CLASS_NAME);
        }
    }

    private static void executeClientDetector() {
        if (clientDetectionClass != null && clientDetectionClass.length() != 0) {
            try {
                defaultClientDetector = (ClientDetectionInterface)Class.forName(clientDetectionClass).newInstance();
            }
            catch (Exception ex) {
                debug.warning("AMClientDetector.executeClientDetector", (Throwable)ex);
            }
        }
    }

    public static boolean isServicePassed() {
        return servicePassed;
    }

    static {
        debug = Debug.getInstance((String)"amClientDetection");
        ClientTypesManagerImpl = null;
        clientDetectionClass = null;
        servicePassed = true;
        AMClientDetector.getServiceSchemaManager();
        if (servicePassed) {
            AMClientDetector.getClientAttributes();
            if (detectionEnabled) {
                AMClientDetector.initClientTypesManager();
                AMClientDetector.executeClientDetector();
            }
        }
    }
}

