/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.CacheBlock;
import com.iplanet.am.sdk.common.CacheStats;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.remote.RemoteServicesImpl;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class CachedRemoteServicesImpl
extends RemoteServicesImpl
implements ICachedDirectoryServices {
    private static int maxSize = 10000;
    private static IDirectoryServices instance = null;
    static final String CACHE_MAX_SIZE_KEY = "com.iplanet.am.sdk.cache.maxSize";
    protected static String NSROLEDN_ATTR = "nsroledn";
    protected static String NSROLE_ATTR = "nsrole";
    private Cache sdkCache;
    private CacheStats cacheStats;

    private static void initializeParams() {
        String cacheSize = SystemProperties.get(CACHE_MAX_SIZE_KEY, "10000");
        try {
            maxSize = Integer.parseInt(cacheSize);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException ne) {
            maxSize = 10000;
            CachedRemoteServicesImpl.getDebug().warning("CachedRemoteServicesImpl.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private CachedRemoteServicesImpl() {
        this.initializeCache();
        this.cacheStats = CacheStats.createInstance(this.getClass().getName(), CachedRemoteServicesImpl.getDebug());
    }

    private void initializeCache() {
        this.sdkCache = new Cache(maxSize);
    }

    public int getSize() {
        return this.sdkCache.size();
    }

    protected static synchronized IDirectoryServices getInstance() {
        if (instance == null) {
            CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getInstance(): Creating new Instance of CachedRemoteServicesImpl()");
            instance = new CachedRemoteServicesImpl();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!this.sdkCache.isEmpty()) {
            Enumeration cacheKeys = this.sdkCache.keys();
            while (cacheKeys.hasMoreElements()) {
                String key = (String)cacheKeys.nextElement();
                CacheBlock cb = (CacheBlock)this.sdkCache.get(key);
                sb.append("\nSDK Cache Block: ").append(key);
                sb.append(cb.toString());
            }
        } else {
            sb.append("<empty>");
        }
        sb.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return sb.toString();
    }

    private void removeCachedAttributes(String affectDNs, Set attrNames) {
        Enumeration cacheKeys = this.sdkCache.keys();
        while (cacheKeys.hasMoreElements()) {
            CacheBlock cb;
            int l2;
            int l1;
            String key = (String)cacheKeys.nextElement();
            if (!key.regionMatches(true, (l1 = key.length()) - (l2 = affectDNs.length()), affectDNs, 0, l2) || (cb = (CacheBlock)this.sdkCache.get(key)) == null || cb.hasExpiredAndUpdated() || !cb.isExists()) continue;
            cb.removeAttributes(attrNames);
        }
    }

    private void clearCachedEntries(String affectDNs) {
        Enumeration cacheKeys = this.sdkCache.keys();
        while (cacheKeys.hasMoreElements()) {
            CacheBlock cb;
            int l2;
            int l1;
            String key = (String)cacheKeys.nextElement();
            if (!key.regionMatches(true, (l1 = key.length()) - (l2 = affectDNs.length()), affectDNs, 0, l2) || (cb = (CacheBlock)this.sdkCache.get(key)) == null) continue;
            cb.clear();
        }
    }

    public void dirtyCache(String dn, int eventType, boolean cosType, boolean aciChange, Set attrNames) {
        String origdn = dn;
        dn = MiscUtils.formatToRFC(dn);
        switch (eventType) {
            case 1: {
                CacheBlock cb = (CacheBlock)this.sdkCache.get(dn);
                if (cb != null) {
                    cb.setExists(true);
                }
                if (!cosType) break;
                this.removeCachedAttributes(dn, attrNames);
                break;
            }
            case 2: {
                CacheBlock cb = (CacheBlock)this.sdkCache.remove(dn);
                if (cb != null) {
                    cb.clear();
                }
                if (!cosType) break;
                this.removeCachedAttributes(dn, attrNames);
                break;
            }
            case 8: {
                CacheBlock cb = (CacheBlock)this.sdkCache.remove(dn);
                if (cb != null) {
                    cb.clear();
                }
                if (!cosType) break;
                this.removeCachedAttributes(dn, attrNames);
                break;
            }
            case 4: {
                CacheBlock cb = (CacheBlock)this.sdkCache.get(dn);
                if (cb != null) {
                    cb.clear();
                }
                if (cosType) {
                    this.removeCachedAttributes(dn, attrNames);
                    break;
                }
                if (!aciChange) break;
                this.clearCachedEntries(dn);
            }
        }
        if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
            CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + eventType + ", cosType: " + cosType + ", aciChange: " + aciChange + ", fullDN: " + origdn + "; rfcDN =" + dn);
        }
    }

    public synchronized void clearCache() {
        this.sdkCache.clear();
        this.initializeCache();
    }

    private synchronized void removeFromCache(String dn) {
        String key = MiscUtils.formatToRFC(dn);
        this.sdkCache.remove(key);
    }

    private void dirtyCache(String dn) {
        String key = MiscUtils.formatToRFC(dn);
        CacheBlock cb = (CacheBlock)this.sdkCache.get(key);
        if (cb != null) {
            cb.clear();
        }
    }

    private void dirtyCache(Set entries) {
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            String entryDN = (String)itr.next();
            String key = MiscUtils.formatToRFC(entryDN);
            CacheBlock cb = (CacheBlock)this.sdkCache.get(key);
            if (cb == null) continue;
            cb.clear();
        }
    }

    private void updateCache(SSOToken token, String dn, Map stringAttributes, Map byteAttributes) throws SSOException {
        String key = MiscUtils.formatToRFC(dn);
        CacheBlock cb = (CacheBlock)this.sdkCache.get(key);
        if (cb != null && !cb.hasExpiredAndUpdated() && cb.isExists()) {
            String pDN = MiscUtils.getPrincipalDN(token);
            cb.replaceAttributes(pDN, stringAttributes, byteAttributes);
        }
    }

    public void createEntry(SSOToken token, String entryName, int objectType, String parentDN, Map attributes) throws AMEntryExistsException, AMException, SSOException {
        super.createEntry(token, entryName, objectType, parentDN, attributes);
        String cacheDN = AMNamingAttrManager.getNamingAttr(objectType) + "=" + entryName + "," + parentDN;
        this.removeFromCache(cacheDN);
    }

    private void validateEntry(SSOToken token, CacheBlock cb) throws AMException {
        if (!cb.hasExpiredAndUpdated() && !cb.isExists()) {
            Object[] params = new String[]{cb.getEntryDN()};
            boolean isPresent = super.doesEntryExists(token, params[0]);
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.validateEntry(): DN" + params[0] + " got from DS & exists: " + isPresent);
            }
            if (isPresent) {
                String dn = MiscUtils.formatToRFC(params[0]);
                cb = new CacheBlock((String)params[0], isPresent);
                this.sdkCache.put(dn, cb);
            } else {
                String locale = MiscUtils.getUserLocale(token);
                throw new AMException(AMSDKBundle.getString("461", params, locale), "461", params);
            }
        }
    }

    public boolean doesEntryExists(SSOToken token, String entryDN) {
        String dn = MiscUtils.formatToRFC(entryDN);
        CacheBlock cb = (CacheBlock)this.sdkCache.get(dn);
        if (cb != null && !cb.hasExpiredAndUpdated()) {
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.doesEntryExist(): entryDN: " + entryDN + " found in cache & exists: " + cb.isExists());
            }
            return cb.isExists();
        }
        boolean isPresent = super.doesEntryExists(token, dn);
        if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
            CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.doesEntryExist(): entryDN: " + entryDN + " got from DS & exists: " + isPresent);
        }
        if (cb == null) {
            cb = new CacheBlock(entryDN, isPresent);
            this.sdkCache.put(dn, cb);
        } else {
            cb.setExists(isPresent);
        }
        return isPresent;
    }

    private void setOrganizationDNs(String organizationDN, Set childDNSet) {
        Iterator itr = childDNSet.iterator();
        while (itr.hasNext()) {
            String cDN = (String)itr.next();
            CacheBlock cb = (CacheBlock)this.sdkCache.get(cDN);
            if (cb == null) {
                cb = new CacheBlock(cDN, organizationDN, true);
                this.sdkCache.put(cDN, cb);
                continue;
            }
            cb.setOrganizationDN(organizationDN);
        }
        if (CachedRemoteServicesImpl.getDebug().messageEnabled() && !childDNSet.isEmpty()) {
            CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.setOrganizationDNs(): Set org DNs as: " + organizationDN + " for children: " + childDNSet);
        }
    }

    public void updateUserAttribute(SSOToken token, Set members, String staticGroupDN, boolean toAdd) throws AMException {
        super.updateUserAttribute(token, members, staticGroupDN, toAdd);
        this.dirtyCache(members);
    }

    public String getOrganizationDN(SSOToken token, String entryDN) throws AMException {
        if (entryDN.length() == 0 || !DN.isDN((String)entryDN)) {
            CachedRemoteServicesImpl.getDebug().error("CachedRemoteServicesImpl.getOrganizationDN() Invalid DN: " + entryDN);
            throw new AMException(token, "157");
        }
        DN dnObject = new DN(entryDN);
        String organizationDN = "";
        HashSet<String> childDNSet = new HashSet<String>();
        boolean errorCondition = false;
        boolean found = false;
        while (!errorCondition && !found) {
            CacheBlock cb;
            boolean lookupDirectory = true;
            String childDN = dnObject.toRFCString().toLowerCase();
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getOrganizationDN() - looping Organization DN for entry: " + childDN);
            }
            if ((cb = (CacheBlock)this.sdkCache.get(childDN)) != null) {
                organizationDN = cb.getOrganizationDN();
                if (organizationDN != null) {
                    if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                        CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getOrganizationDN(): found OrganizationDN: " + organizationDN + " for: " + childDN);
                    }
                    found = true;
                    this.setOrganizationDNs(organizationDN, childDNSet);
                    continue;
                }
                if (cb.getObjectType() == 2 || cb.getObjectType() == 3) {
                    organizationDN = childDN;
                    found = true;
                    childDNSet.add(childDN);
                    this.setOrganizationDNs(organizationDN, childDNSet);
                    continue;
                }
                if (cb.getObjectType() != -9999) {
                    lookupDirectory = false;
                }
            }
            childDNSet.add(childDN);
            if (lookupDirectory) {
                organizationDN = super.verifyAndGetOrgDN(token, entryDN, childDN);
            }
            if (organizationDN != null && organizationDN.length() > 0) {
                found = true;
                this.setOrganizationDNs(organizationDN, childDNSet);
                continue;
            }
            if (dnObject.countRDNs() == 1) {
                errorCondition = true;
                CachedRemoteServicesImpl.getDebug().error("CachedRemoteServicesImpl.getOrganizationDN(): Reached root suffix. Unable to get parent Org");
                continue;
            }
            dnObject = dnObject.getParent();
        }
        return organizationDN;
    }

    public int getObjectType(SSOToken token, String dn) throws AMException, SSOException {
        int objectType = -9999;
        String entryDN = MiscUtils.formatToRFC(dn);
        CacheBlock cb = (CacheBlock)this.sdkCache.get(entryDN);
        if (cb != null) {
            if (!this.doesEntryExists(token, dn)) {
                String locale = MiscUtils.getUserLocale(token);
                Object[] params = new String[]{cb.getEntryDN()};
                throw new AMException(AMSDKBundle.getString("461", params, locale), "461", params);
            }
            this.validateEntry(token, cb);
            objectType = cb.getObjectType();
            if (objectType != -9999) {
                return objectType;
            }
        }
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (cb == null) {
            objectType = super.getObjectType(adminToken, entryDN);
            cb = new CacheBlock(entryDN, true);
            this.sdkCache.put(entryDN, cb);
        } else {
            objectType = super.getObjectType(adminToken, entryDN, cb.getAttributes(MiscUtils.getPrincipalDN(adminToken), false));
        }
        cb.setObjectType(objectType);
        if (objectType == 2 || objectType == 3) {
            cb.setOrganizationDN(entryDN);
        }
        return objectType;
    }

    public Map getExternalAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException {
        String eDN = profileType == 1 ? new DN(entryDN).getParent().toString() : entryDN;
        String orgDN = this.getOrganizationDN(token, eDN);
        if (this.callBackHelperBase.isExternalGetAttributesEnabled(orgDN)) {
            return super.getExternalAttributes(token, entryDN, attrNames, profileType);
        }
        return null;
    }

    public Map getAttributes(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        boolean ignoreCompliance = true;
        boolean byteValues = false;
        return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        boolean ignoreCompliance = true;
        boolean byteValues = false;
        return this.getAttributes(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        boolean byteValues = true;
        boolean ignoreCompliance = true;
        return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        boolean byteValues = true;
        boolean ignoreCompliance = true;
        return this.getAttributes(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributes(SSOToken token, String entryDN, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        this.cacheStats.incrementRequestCount(this.getSize());
        String principalDN = MiscUtils.getPrincipalDN(token);
        String dn = MiscUtils.formatToRFC(entryDN);
        if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
            CachedRemoteServicesImpl.getDebug().message("In CachedRemoteServicesImpl.getAttributes(SSOToken entryDN, ignoreCompliance) (" + principalDN + ", " + entryDN + ", " + ignoreCompliance + " method.");
        }
        CacheBlock cb = (CacheBlock)this.sdkCache.get(dn);
        AMHashMap attributes = null;
        if (cb != null) {
            this.validateEntry(token, cb);
            if (cb.hasCompleteSet(principalDN)) {
                this.cacheStats.updateHitCount(this.getSize());
                if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                    CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): found all attributes in Cache.");
                }
                attributes = (AMHashMap)cb.getAttributes(principalDN, byteValues);
            } else {
                if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                    CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  complete attribute set NOT found in cache. Getting from DS.");
                }
                attributes = (AMHashMap)super.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
                cb.putAttributes(principalDN, attributes, null, true, byteValues);
            }
        } else {
            attributes = (AMHashMap)super.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
            cb = new CacheBlock(entryDN, true);
            cb.putAttributes(principalDN, attributes, null, true, byteValues);
            this.sdkCache.put(dn, cb);
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        Map extAttributes = this.getExternalAttributes(token, entryDN, null, profileType);
        if (extAttributes != null && !extAttributes.isEmpty()) {
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): External attributes present. Adding them with original list");
            }
            attributes.putAll(extAttributes);
        }
        return attributes;
    }

    private AMHashMap getPluginAttrsAndUpdateCache(SSOToken token, String principalDN, String entryDN, CacheBlock cb, AMHashMap attributes, Set missAttrNames, boolean byteValues, int profileType) throws AMException {
        Map extAttributes = this.getExternalAttributes(token, entryDN, missAttrNames, profileType);
        if (extAttributes != null && !extAttributes.isEmpty()) {
            Set extAttrNames = extAttributes.keySet();
            cb.removeAttributes(extAttrNames);
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getPluginAttrsAndUpdateCache(): External attributes present. Adding them with original list. External Attributes: " + extAttrNames);
            }
            attributes.putAll(extAttributes);
        }
        return attributes;
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        String dn;
        CacheBlock cb;
        if (attrNames == null || attrNames.isEmpty()) {
            return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
        }
        this.cacheStats.incrementRequestCount(this.getSize());
        if (this.dcTreeServicesImpl.isRequired()) {
            this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
        }
        String principalDN = MiscUtils.getPrincipalDN(token);
        if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
            CachedRemoteServicesImpl.getDebug().message("In CachedRemoteServicesImpl.getAttributes(SSOToken entryDN, attrNames, ignoreCompliance, byteValues) (" + principalDN + ", " + entryDN + ", " + attrNames + ", " + ignoreCompliance + ", " + byteValues + " method.");
        }
        if ((cb = (CacheBlock)this.sdkCache.get(dn = MiscUtils.formatToRFC(entryDN))) == null) {
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  NO entry found in Cache. Getting all these attributes from DS: " + attrNames);
            }
            AMHashMap attributes = (AMHashMap)super.getAttributes(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
            Set missAttrNames = attributes.getMissingAndEmptyKeys(attrNames);
            cb = new CacheBlock(dn, true);
            cb.putAttributes(principalDN, attributes, missAttrNames, false, byteValues);
            this.sdkCache.put(dn, cb);
            if (!missAttrNames.isEmpty()) {
                attributes = this.getPluginAttrsAndUpdateCache(token, principalDN, entryDN, cb, attributes, missAttrNames, byteValues, profileType);
            }
            return attributes;
        }
        this.validateEntry(token, cb);
        AMHashMap attributes = (AMHashMap)cb.getAttributes(principalDN, attrNames, byteValues);
        Set missAttrNames = attributes.getMissingKeys(attrNames);
        if (!missAttrNames.isEmpty()) {
            boolean isComplete = cb.hasCompleteSet(principalDN);
            AMHashMap dsAttributes = null;
            if (!isComplete || missAttrNames.contains(NSROLEDN_ATTR) || missAttrNames.contains(NSROLE_ATTR)) {
                if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                    CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): Trying to get these missing attributes from DS: " + missAttrNames);
                }
                if ((dsAttributes = (AMHashMap)super.getAttributes(token, entryDN, missAttrNames, ignoreCompliance, byteValues, profileType)) != null) {
                    attributes.putAll(dsAttributes);
                    Set newMissAttrNames = dsAttributes.getMissingAndEmptyKeys(missAttrNames);
                    dsAttributes.putAll(cb.getAttributes(principalDN, byteValues));
                    cb.putAttributes(principalDN, dsAttributes, newMissAttrNames, isComplete, byteValues);
                    missAttrNames = newMissAttrNames;
                }
            } else {
                cb.putAttributes(principalDN, cb.getAttributes(principalDN, byteValues), missAttrNames, isComplete, byteValues);
            }
            if (!missAttrNames.isEmpty()) {
                attributes = this.getPluginAttrsAndUpdateCache(token, principalDN, entryDN, cb, attributes, missAttrNames, byteValues, profileType);
            }
        } else {
            if (CachedRemoteServicesImpl.getDebug().messageEnabled()) {
                CachedRemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  found all attributes in Cache.");
            }
            this.cacheStats.updateHitCount(this.getSize());
        }
        return attributes;
    }

    public String renameEntry(SSOToken token, int objectType, String entryDN, String newName, boolean deleteOldName) throws AMException {
        String newDN = super.renameEntry(token, objectType, entryDN, newName, deleteOldName);
        String oldDN = MiscUtils.formatToRFC(entryDN);
        CacheBlock cb = (CacheBlock)this.sdkCache.remove(oldDN);
        newDN = MiscUtils.formatToRFC(newDN);
        this.sdkCache.put(newDN, cb);
        return newDN;
    }

    public void setAttributes(SSOToken token, String entryDN, int objectType, Map stringAttributes, Map byteAttributes, boolean isAdd) throws AMException, SSOException {
        super.setAttributes(token, entryDN, objectType, stringAttributes, byteAttributes, isAdd);
        if (objectType == 1) {
            this.updateCache(token, entryDN, stringAttributes, byteAttributes);
        } else if (objectType != 1) {
            this.dirtyCache(entryDN);
        }
    }

    public void removeEntry(SSOToken token, String entryDN, int objectType, boolean recursive, boolean softDelete) throws AMException, SSOException {
        super.removeEntry(token, entryDN, objectType, recursive, softDelete);
        this.removeFromCache(entryDN);
    }

    public String createAMTemplate(SSOToken token, String entryDN, int objectType, String serviceName, Map attributes, int priority) throws AMException {
        String templateDN = super.createAMTemplate(token, entryDN, objectType, serviceName, attributes, priority);
        String dn = MiscUtils.formatToRFC(templateDN);
        CacheBlock cb = (CacheBlock)this.sdkCache.get(dn);
        if (cb != null) {
            cb.setExists(true);
        }
        return templateDN;
    }

    public void setGroupFilter(SSOToken token, String entryDN, String filter) throws AMException, SSOException {
        super.setGroupFilter(token, entryDN, filter);
    }

    static {
        CachedRemoteServicesImpl.initializeParams();
    }
}

