/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SchemaType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import netscape.ldap.util.DN;

public class EmailNotificationHelper {
    public static final String ADMINISTRATION_SERVICE = "iPlanetAMAdminConsoleService";
    public static final String USER_CREATE_NOTIFICATION_LIST = "iplanet-am-user-create-notification-list";
    public static final String USER_DELETE_NOTIFICATION_LIST = "iplanet-am-user-delete-notification-list";
    public static final String USER_MODIFY_NOTIFICATION_LIST = "iplanet-am-user-modify-notification-list";
    public static final String EMAIL_ATTRIBUTE = "mail";
    private static SSOToken internalToken = CommonUtils.getInternalToken();
    private static Debug debug = CommonUtils.getDebugInstance();
    private AMSendMail mailer = null;
    private String entryDN;
    private String organizationDN;
    private Set createNotifyList = Collections.EMPTY_SET;
    private Set deleteNotifyList = Collections.EMPTY_SET;
    private Set modifyNotifyList = Collections.EMPTY_SET;

    public EmailNotificationHelper(String userDN) {
        this.entryDN = userDN;
        this.organizationDN = new DN(userDN).getParent().toString();
        this.mailer = new AMSendMail();
    }

    private void sendEmail(Set notifyList, Map attributes, String fromCode, String subjectCode, String messageCode) throws MessagingException {
        String self = AMSDKBundle.getString("504");
        Iterator iter = notifyList.iterator();
        while (iter.hasNext()) {
            String[] to;
            StringTokenizer stz = new StringTokenizer((String)iter.next(), "|");
            String emailStr = stz.nextToken();
            if (emailStr.equals(self)) {
                Set emails = (Set)attributes.get(EMAIL_ATTRIBUTE);
                if (emails == null || emails.isEmpty()) continue;
                if (debug.messageEnabled()) {
                    debug.message("EmailNotificationHelper.sendMail(): Converting to array for: " + emails);
                }
                to = emails.toArray(new String[emails.size()]);
            } else if (emailStr.startsWith(self + ":")) {
                Set emails;
                String attrName = emailStr.substring((self + ":").length());
                if (attrName == null || attrName.length() == 0 || (emails = (Set)attributes.get(attrName)) == null || emails.isEmpty()) continue;
                if (debug.messageEnabled()) {
                    debug.message("EmailNotificationHelper.sendMail(): Converting to array for: " + emails);
                }
                to = emails.toArray(new String[emails.size()]);
            } else {
                to = new String[]{emailStr};
            }
            String locale = null;
            String charset = null;
            if (stz.hasMoreTokens()) {
                locale = stz.nextToken();
                if (stz.hasMoreTokens()) {
                    charset = stz.nextToken();
                }
            }
            String from = AMSDKBundle.getString(fromCode, locale);
            String subject = AMSDKBundle.getString(subjectCode, locale);
            String message = AMSDKBundle.getString(messageCode, locale) + " " + this.entryDN;
            this.mailer.postMail(to, subject, message, from, charset);
        }
    }

    private Set getNotificationList(String attributeName) {
        Set notifyList = Collections.EMPTY_SET;
        try {
            String organizationDN = DirectoryServicesFactory.getInstance().getOrganizationDN(internalToken, this.organizationDN);
            AMStoreConnection amsc = new AMStoreConnection(internalToken);
            AMOrganization amOrg = amsc.getOrganization(organizationDN);
            notifyList = this.getOrgTypeAttributes(amOrg, ADMINISTRATION_SERVICE, attributeName);
        }
        catch (AMException ae) {
            debug.error("EmailNotificationHelper.getNotificationList() Unable to get notification List for " + attributeName + " for user: " + this.entryDN, (Throwable)ae);
        }
        catch (SSOException e) {
            debug.error("EmailNotificationHelper.getNotificationList() Unable to get notification List for " + attributeName + " for user: " + this.entryDN, (Throwable)((Object)e));
        }
        return notifyList;
    }

    public void setUserCreateNotificationList() {
        this.createNotifyList = this.getNotificationList(USER_CREATE_NOTIFICATION_LIST);
    }

    public void setUserDeleteNotificationList() {
        this.deleteNotifyList = this.getNotificationList(USER_DELETE_NOTIFICATION_LIST);
    }

    public void setUserModifyNotificationList() {
        this.modifyNotifyList = this.getNotificationList(USER_MODIFY_NOTIFICATION_LIST);
    }

    public boolean isPresentUserCreateNotificationList() {
        return this.createNotifyList != null && !this.createNotifyList.isEmpty();
    }

    public boolean isPresentUserDeleteNotificationList() {
        return this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty();
    }

    public boolean isPresentUserModifyNotificationList() {
        return this.modifyNotifyList != null && !this.modifyNotifyList.isEmpty();
    }

    public void sendUserCreateNotification(Map attributes) {
        block3: {
            try {
                if (this.createNotifyList != null && !this.createNotifyList.isEmpty()) {
                    this.sendEmail(this.createNotifyList, attributes, "497", "490", "493");
                }
            }
            catch (MessagingException e) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("EmailNotificationHelper.sendUserCreateNotification() Unable to send email for user: " + this.entryDN, (Throwable)e);
            }
        }
    }

    public void sendUserDeleteNotification(Map attributes) {
        block3: {
            try {
                if (this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty()) {
                    this.sendEmail(this.deleteNotifyList, attributes, "497", "491", "494");
                }
            }
            catch (MessagingException e) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("EmailNotificationHelper.sendUserDeleteNotification() Unable to send email for user: " + this.entryDN, (Throwable)e);
            }
        }
    }

    public void sendUserModifyNotification(SSOToken token, Map attributes, Map oldAttributes) {
        if (this.modifyNotifyList == null || this.modifyNotifyList.isEmpty()) {
            return;
        }
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        AttrSet oldAttrSet = CommonUtils.mapToAttrSet(oldAttributes);
        try {
            String self = AMSDKBundle.getString("504");
            Iterator iter = this.modifyNotifyList.iterator();
            while (iter.hasNext()) {
                String oldStr;
                String newStr;
                int i;
                String val = (String)iter.next();
                StringTokenizer stz = new StringTokenizer(val);
                int toLen = stz.countTokens();
                if (toLen <= 0) continue;
                String attrName = stz.nextToken().toLowerCase();
                boolean valuesChanged = false;
                Attr newAttrVal = null;
                Attr oldAttrVal = null;
                StringBuffer newSB = new StringBuffer();
                StringBuffer oldSB = new StringBuffer();
                if (attrSet.contains(attrName) && (newAttrVal = attrSet.getAttribute(attrName)) != null) {
                    String[] newvalues = newAttrVal.getStringValues();
                    for (i = 0; i < newvalues.length; ++i) {
                        newSB.append(newvalues[i]);
                    }
                }
                if (oldAttrSet.contains(attrName) && (oldAttrVal = oldAttrSet.getAttribute(attrName)) != null) {
                    String[] oldvalues = oldAttrVal.getStringValues();
                    for (i = 0; i < oldvalues.length; ++i) {
                        oldSB.append(oldvalues[i]);
                    }
                }
                if (!(valuesChanged = !(newStr = newSB.toString()).equalsIgnoreCase(oldStr = oldSB.toString()))) continue;
                while (stz.hasMoreTokens()) {
                    int i2;
                    String[] values;
                    String[] to;
                    StringTokenizer stz2 = new StringTokenizer(stz.nextToken(), "|");
                    String email = stz2.nextToken();
                    if (email.equals(self)) {
                        HashSet<String> attrNamesSet = new HashSet<String>(1);
                        attrNamesSet.add(EMAIL_ATTRIBUTE);
                        Map emailAttrMap = DirectoryServicesFactory.getInstance().getAttributes(token, this.entryDN, attrNamesSet, 1);
                        Set emails = (Set)emailAttrMap.get(EMAIL_ATTRIBUTE);
                        if (emails == null || emails.isEmpty()) continue;
                        to = emails.toArray(new String[emails.size()]);
                    } else if (email.startsWith(self + ":")) {
                        String emailAttrName = email.substring((self + ":").length());
                        if (emailAttrName == null || emailAttrName.length() == 0) continue;
                        HashSet<String> attrNamesSet = new HashSet<String>(1);
                        attrNamesSet.add(emailAttrName);
                        Map emailAttrMap = DirectoryServicesFactory.getInstance().getAttributes(token, this.entryDN, attrNamesSet, 1);
                        Set emails = (Set)emailAttrMap.get(emailAttrName);
                        if (emails == null || emails.isEmpty()) continue;
                        to = emails.toArray(new String[emails.size()]);
                    } else {
                        to = new String[]{email};
                    }
                    String locale = null;
                    String charset = null;
                    if (stz2.hasMoreTokens()) {
                        locale = stz2.nextToken();
                        if (stz2.hasMoreTokens()) {
                            charset = stz2.nextToken();
                        }
                    }
                    Attr oldAttr = oldAttrSet.getAttribute(attrName);
                    Attr newAttr = attrSet.getAttribute(attrName);
                    String sub = AMSDKBundle.getString("492", locale);
                    StringBuffer msgSB = new StringBuffer();
                    msgSB.append(AMSDKBundle.getString("495", locale)).append(" ").append(this.entryDN).append("\n").append(AMSDKBundle.getString("496", locale)).append(" ").append(attrName).append("\n").append(AMSDKBundle.getString("502", locale)).append("\n");
                    if (oldAttr != null) {
                        values = oldAttr.getStringValues();
                        for (i2 = 0; i2 < values.length; ++i2) {
                            msgSB.append("    ").append(values[i2]).append("\n");
                        }
                    }
                    msgSB.append(AMSDKBundle.getString("503", locale)).append("\n");
                    if (newAttr != null) {
                        values = newAttr.getStringValues();
                        for (i2 = 0; i2 < values.length; ++i2) {
                            msgSB.append("    ").append(values[i2]).append("\n");
                        }
                    }
                    String from = AMSDKBundle.getString("497", locale);
                    this.mailer.postMail(to, sub, msgSB.toString(), from, charset);
                }
            }
        }
        catch (MessagingException me) {
            if (debug.warningEnabled()) {
                debug.warning("EmailNotificationHelper.sendUserModifyNotification() Unable to send email for user: " + this.entryDN, (Throwable)me);
            }
        }
        catch (SSOException e) {
            debug.error("EmailNotificationHelper.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)((Object)e));
        }
        catch (AMException ex) {
            debug.error("EmailNotificationHelper.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)ex);
        }
    }

    protected Set getOrgTypeAttributes(AMOrganization org, String serviceName, String attrName) throws SSOException {
        Set attrValues = null;
        try {
            AMTemplate amTemplate = org.getTemplate(serviceName, 302);
            attrValues = amTemplate.getAttribute(attrName);
            if (debug.messageEnabled()) {
                debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org template " + serviceName + " : " + attrName + "\n" + org.getDN() + " : " + attrValues);
            }
        }
        catch (AMException ame) {
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(internalToken, ADMINISTRATION_SERVICE, SchemaType.ORGANIZATION);
                attrValues = (Set)defaultValues.get(attrName);
                if (debug.messageEnabled()) {
                    debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org defaults " + serviceName + " : " + attrName + "\n" + org.getDN() + " : " + attrValues);
                }
            }
            catch (Exception se) {
                debug.warning("AMOrganizationImpl.getOrgTypeAttributes(): Error encountered in retrieving default org attrs for", (Throwable)se);
            }
        }
        return attrValues;
    }
}

