/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.sdk.ldap.EventManager;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ACIEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(aci=*)";
    protected static final int OPERATIONS = 15;
    private Debug debug = EventManager.getDebug();
    private Map listeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryChanged(DSEvent dsEvent) {
        String objClasses;
        if (this.debug.messageEnabled()) {
            this.debug.message("ACIEventListener.entryChanged() DSEvent for dn: " + dsEvent.getID());
        }
        if ((objClasses = dsEvent.getClassName()).indexOf("cosClassicDefinition") != -1 || objClasses.indexOf("costemplate") != -1) {
            return;
        }
        String affectedDNs = CommonUtils.formatToRFC(dsEvent.getID());
        IDirectoryServices dsServices = DirectoryServicesFactory.getInstance();
        if (DirectoryServicesFactory.isCachingEnabled()) {
            ((ICachedDirectoryServices)dsServices).dirtyCache(affectedDNs, dsEvent.getEventType(), false, true, Collections.EMPTY_SET);
        }
        Map map = this.listeners;
        synchronized (map) {
            Set keys = this.listeners.keySet();
            Iterator items = keys.iterator();
            while (items.hasNext()) {
                AMObjectListener listener = (AMObjectListener)items.next();
                if (dsEvent.getEventType() == 4) {
                    listener.permissionsChanged(dsEvent.getID(), (Map)this.listeners.get(listener));
                    continue;
                }
                listener.objectChanged(affectedDNs, dsEvent.getEventType(), (Map)this.listeners.get(listener));
            }
        }
    }

    public void eventError(String errorStr) {
        this.debug.error("ACIEventListener.eventError(): " + errorStr);
    }

    public void allEntriesChanged() {
    }

    public String getBase() {
        return EventManager.EVENT_BASE_NODE;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map listener) {
        this.listeners = listener;
    }
}

