/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.graph.action.Script;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Join
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    String parentLockMode;
    boolean isDiscriminator = false;
    Collection tokenNames = null;
    Script script = null;
    int nOutOfM = -1;
    private static final Log log = LogFactory.getLog((Class)Join.class);

    public Join() {
    }

    public Join(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Join;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        String lock = element.attributeValue("lock");
        if (lock != null) {
            LockMode lockMode = LockMode.parse((String)lock);
            if (lockMode != null) {
                this.parentLockMode = lockMode.toString();
            } else if ("pessimistic".equals(lock)) {
                this.parentLockMode = LockMode.UPGRADE.toString();
            } else {
                jpdlReader.addError("invalid parent lock mode '" + lock + "'");
            }
        }
    }

    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        boolean isAbleToReactivateParent = token.isAbleToReactivateParent();
        if (!token.hasEnded()) {
            token.end(false);
        }
        if (isAbleToReactivateParent) {
            token.setAbleToReactivateParent(false);
            Token parentToken = token.getParent();
            if (parentToken != null) {
                boolean reactivateParent;
                Session session;
                JbpmContext jbpmContext = executionContext.getJbpmContext();
                if (jbpmContext != null && (session = jbpmContext.getSession()) != null) {
                    LockMode lockMode = this.parentLockMode != null ? LockMode.parse((String)this.parentLockMode) : LockMode.UPGRADE;
                    log.debug((Object)("acquiring " + lockMode + " lock on " + parentToken));
                    session.lock((Object)parentToken, lockMode);
                }
                if (this.isDiscriminator) {
                    reactivateParent = true;
                } else if (this.tokenNames != null) {
                    reactivateParent = this.mustParentBeReactivated(parentToken, this.tokenNames.iterator());
                } else if (this.script != null) {
                    Map result = null;
                    try {
                        result = this.script.eval(token);
                    }
                    catch (Exception e) {
                        this.raiseException(e, executionContext);
                    }
                    if (result instanceof Collection) {
                        Collection runtimeTokenNames = (Collection)((Object)result);
                        reactivateParent = this.mustParentBeReactivated(parentToken, runtimeTokenNames.iterator());
                    } else {
                        reactivateParent = result instanceof Boolean ? (Boolean)((Object)result) : result != null;
                    }
                } else if (this.nOutOfM != -1) {
                    int n = 0;
                    Iterator iter = parentToken.getChildren().values().iterator();
                    while (iter.hasNext()) {
                        Token concurrentToken = (Token)iter.next();
                        if (!this.equals(concurrentToken.getNode())) continue;
                        ++n;
                    }
                    reactivateParent = n >= this.nOutOfM;
                } else {
                    reactivateParent = this.mustParentBeReactivated(parentToken, parentToken.getChildren().keySet().iterator());
                }
                if (reactivateParent) {
                    Iterator iter = parentToken.getChildren().values().iterator();
                    while (iter.hasNext()) {
                        Token concurrentToken = (Token)iter.next();
                        concurrentToken.setAbleToReactivateParent(false);
                    }
                    ExecutionContext parentContext = new ExecutionContext(parentToken);
                    this.leave(parentContext);
                }
            }
        }
    }

    public boolean mustParentBeReactivated(Token parentToken, Iterator concurrentTokenNames) {
        while (concurrentTokenNames.hasNext()) {
            String concurrentTokenName = (String)concurrentTokenNames.next();
            Token concurrentToken = parentToken.getChild(concurrentTokenName);
            if (!concurrentToken.isAbleToReactivateParent()) continue;
            log.debug((Object)("join will not reactivate parent yet, found concurrent " + concurrentToken));
            return false;
        }
        return true;
    }

    public String getParentLockMode() {
        return this.parentLockMode;
    }

    public void setParentLockMode(String parentLockMode) {
        this.parentLockMode = parentLockMode;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public Collection getTokenNames() {
        return this.tokenNames;
    }

    public void setTokenNames(Collection tokenNames) {
        this.tokenNames = tokenNames;
    }

    public boolean isDiscriminator() {
        return this.isDiscriminator;
    }

    public void setDiscriminator(boolean isDiscriminator) {
        this.isDiscriminator = isDiscriminator;
    }

    public int getNOutOfM() {
        return this.nOutOfM;
    }

    public void setNOutOfM(int nOutOfM) {
        this.nOutOfM = nOutOfM;
    }
}

