/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerExt;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.AbstractWebDeployer;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.service.DeployerConfig;
import org.jboss.web.tomcat.service.JBossWebMBean;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;

public class JBossWeb
extends AbstractWebContainer
implements JBossWebMBean,
NotificationListener {
    public static final String NAME = "JBossWeb";
    public static final String DEFAULT_CACHE_NAME = "jboss.cache:service=TomcatClusteringCache";
    private String contextClassName = "org.apache.catalina.core.StandardContext";
    private Properties authenticators = null;
    private String catalinaDomain = "Catalina";
    private String cacheName = "jboss.cache:service=TomcatClusteringCache";
    protected String managerClass = "org.jboss.web.tomcat.service.session.JBossCacheManager";
    private int snapshotInterval = 1000;
    private String snapshotMode = "instant";
    private boolean useLocalCache = true;
    private boolean useJK = false;
    private int maxUnreplicatedInterval = 60;
    private boolean useJBossWebLoader = true;
    private boolean deleteWorkDirOnContextDestroy = false;
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;
    private String serverConfigFile = "server.xml";
    private String subjectAttributeName = null;
    private boolean allowSelfPrivilegedWebApps = false;
    private JaasSecurityManagerServiceMBean secMgrService;
    private String[] filteredPackages;
    private SubDeployerExt thisProxy;

    public String getName() {
        return NAME;
    }

    public String getManagerClass() {
        return this.managerClass;
    }

    public void setManagerClass(String managerClass) {
        this.managerClass = managerClass;
    }

    public String getDomain() {
        return this.catalinaDomain;
    }

    public Properties getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Properties prop) {
        this.authenticators = prop;
        this.log.debug((Object)("Passed set of authenticators=" + prop));
    }

    public void setDomain(String catalinaDomain) {
        this.catalinaDomain = catalinaDomain;
    }

    public void setContextMBeanCode(String className) {
        this.contextClassName = className;
    }

    public String getContextMBeanCode() {
        return this.contextClassName;
    }

    public void setSnapshotInterval(int interval) {
        this.snapshotInterval = interval;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void setSnapshotMode(String mode) {
        this.snapshotMode = mode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public boolean isUseJK() {
        return this.useJK;
    }

    public void setUseJK(boolean useJK) {
        this.useJK = useJK;
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.deleteWorkDirOnContextDestroy;
    }

    public void setDeleteWorkDirOnContextDestroy(boolean deleteFlag) {
        this.deleteWorkDirOnContextDestroy = deleteFlag;
    }

    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    public void setHttpHeaderForSSOAuth(String httpHeader) {
        this.httpHeaderForSSOAuth = httpHeader;
    }

    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    public void setSessionCookieForSSOAuth(String sessionC) {
        this.sessionCookieForSSOAuth = sessionC;
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        SessionIDGenerator.getInstance().setSessionIdAlphabet(sessionIdAlphabet);
    }

    public String getSessionIdAlphabet() {
        return SessionIDGenerator.getInstance().getSessionIdAlphabet();
    }

    public boolean getUseJBossWebLoader() {
        return this.useJBossWebLoader;
    }

    public void setUseJBossWebLoader(boolean flag) {
        this.useJBossWebLoader = flag;
    }

    public String getConfigFile() {
        return this.serverConfigFile;
    }

    public void setConfigFile(String configFile) {
        this.serverConfigFile = configFile;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String name) {
        this.subjectAttributeName = name;
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.allowSelfPrivilegedWebApps;
    }

    public void setAllowSelfPrivilegedWebApps(boolean allowSelfPrivilegedWebApps) {
        this.allowSelfPrivilegedWebApps = allowSelfPrivilegedWebApps;
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        this.secMgrService = mgr;
    }

    public String[] getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String[] pkgs) {
        this.filteredPackages = pkgs;
    }

    public void startService() throws Exception {
        System.setProperty("catalina.ext.dirs", System.getProperty("jboss.server.home.dir") + File.separator + "lib");
        String objectNameS = this.catalinaDomain + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        Registry.getRegistry().setMBeanServer(this.server);
        Registry.getRegistry().registerComponent(Class.forName("org.apache.catalina.startup.Catalina").newInstance(), objectName, "org.apache.catalina.startup.Catalina");
        this.server.setAttribute(objectName, new Attribute("catalinaHome", System.getProperty("jboss.server.home.dir")));
        this.server.setAttribute(objectName, new Attribute("configFile", this.serverConfigFile));
        this.server.setAttribute(objectName, new Attribute("useNaming", new Boolean(false)));
        this.server.setAttribute(objectName, new Attribute("useShutdownHook", new Boolean(false)));
        this.server.setAttribute(objectName, new Attribute("await", new Boolean(false)));
        this.server.setAttribute(objectName, new Attribute("redirectStreams", new Boolean(false)));
        this.server.invoke(objectName, "create", new Object[0], new String[0]);
        this.server.invoke(objectName, "start", new Object[0], new String[0]);
        ObjectName ssoQuery = new ObjectName("*:type=Valve,*");
        Iterator<ObjectInstance> iterator = this.server.queryMBeans(ssoQuery, null).iterator();
        while (iterator.hasNext()) {
            String tcName;
            ObjectName ssoCacheName;
            ObjectName ssoObjectName = iterator.next().getObjectName();
            String name = ssoObjectName.getKeyProperty("name");
            if (this.cacheName == null || !"ClusteredSingleSignOn".equals(name) || !(ssoCacheName = new ObjectName(tcName = (tcName = (String)this.server.getAttribute(ssoObjectName, "treeCacheName")) != null ? tcName : DEFAULT_CACHE_NAME)).equals(new ObjectName(DEFAULT_CACHE_NAME))) continue;
            this.log.info((Object)("Setting the cache name to " + this.cacheName + " on " + ssoObjectName));
            this.server.setAttribute(ssoObjectName, new Attribute("treeCacheName", this.cacheName));
        }
        HttpServletRequestPolicyContextHandler handler = new HttpServletRequestPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.thisProxy = (SubDeployerExt)MBeanProxyExt.create(SubDeployerExt.class, (ObjectName)super.getServiceName(), (MBeanServer)super.getServer());
        this.mainDeployer.addDeployer((SubDeployer)this.thisProxy);
        Boolean started = (Boolean)this.server.getAttribute(ServerImplMBean.OBJECT_NAME, "Started");
        if (started.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, starting connectors now"));
            this.startConnectors();
        } else {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' not started, registering for start-up notification"));
            this.server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    public void stopService() throws Exception {
        String objectNameS = this.catalinaDomain + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        this.server.invoke(objectName, "stop", new Object[0], new String[0]);
        this.server.invoke(objectName, "destroy", new Object[0], new String[0]);
        this.server.unregisterMBean(objectName);
        MBeanServer server2 = this.server;
        this.mainDeployer.removeDeployer((SubDeployer)this.thisProxy);
        ObjectName queryObjectName = new ObjectName(this.catalinaDomain + ":*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName toRemove = oi.getObjectName();
            if ("WebServer".equals(toRemove.getKeyProperty("service")) || !server2.isRegistered(toRemove)) continue;
            server2.unregisterMBean(toRemove);
        }
        queryObjectName = new ObjectName("Catalina:*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName name = oi.getObjectName();
            server2.unregisterMBean(name);
        }
    }

    public void startConnectors() throws Exception {
        ObjectName service = new ObjectName(this.catalinaDomain + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])this.server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.start();
        }
        this.startAllConnectors();
        this.sendNotification(new Notification("jboss.tomcat.connectors.started", this, this.getNextNotificationSequenceNumber()));
    }

    public void stopConnectors() throws Exception {
        ObjectName service = new ObjectName(this.catalinaDomain + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])this.server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.stop();
        }
        this.stopAllConnectors();
    }

    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting connectors"));
            try {
                this.startConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to startConnectors", (Throwable)e);
            }
        }
    }

    public AbstractWebDeployer getDeployer(DeploymentInfo di) throws Exception {
        RepositoryClassLoader loader = di.ucl;
        Class<?> deployerClass = loader.loadClass("org.jboss.web.tomcat.service.TomcatDeployer");
        AbstractWebDeployer deployer = (AbstractWebDeployer)deployerClass.newInstance();
        DeployerConfig config = new DeployerConfig();
        config.setDefaultSecurityDomain(this.defaultSecurityDomain);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setServiceClassLoader(this.getClass().getClassLoader());
        config.setManagerClass(this.managerClass);
        config.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
        config.setUnpackWars(this.unpackWars);
        config.setLenientEjbLink(this.lenientEjbLink);
        config.setCatalinaDomain(this.catalinaDomain);
        config.setContextClassName(this.contextClassName);
        config.setServiceName(this.serviceName);
        config.setSnapshotInterval(this.snapshotInterval);
        config.setSnapshotMode(this.snapshotMode);
        config.setUseLocalCache(this.useLocalCache);
        config.setUseJK(this.useJK);
        config.setMaxUnreplicatedInterval(this.maxUnreplicatedInterval);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setUseJBossWebLoader(this.useJBossWebLoader);
        config.setAllowSelfPrivilegedWebApps(this.allowSelfPrivilegedWebApps);
        config.setSecurityManagerService(this.secMgrService);
        config.setFilteredPackages(this.filteredPackages);
        deployer.setServer(this.server);
        deployer.init((Object)config);
        return deployer;
    }

    private void startAllConnectors() throws JMException, LifecycleException {
        ObjectName oname = new ObjectName("*:type=Service,*");
        Set<ObjectInstance> services = this.server.queryMBeans(oname, null);
        for (ObjectInstance oi : services) {
            String key;
            ObjectName on = oi.getObjectName();
            if (this.catalinaDomain.equals(on.getDomain()) || (key = on.getKeyProperty("serviceName")) == null) continue;
            Connector[] connectors = (Connector[])this.server.invoke(on, "findConnectors", new Object[0], new String[0]);
            for (int n = 0; n < connectors.length; ++n) {
                Connector lc = connectors[n];
                lc.start();
            }
        }
    }

    private void stopAllConnectors() throws JMException, LifecycleException {
        ObjectName oname = new ObjectName("*:type=Service,*");
        Set<ObjectInstance> services = this.server.queryMBeans(oname, null);
        for (ObjectInstance oi : services) {
            String key;
            ObjectName on = oi.getObjectName();
            if (this.catalinaDomain.equals(on.getDomain()) || (key = on.getKeyProperty("serviceName")) == null) continue;
            Connector[] connectors = (Connector[])this.server.invoke(on, "findConnectors", new Object[0], new String[0]);
            for (int n = 0; n < connectors.length; ++n) {
                Connector lc = connectors[n];
                lc.stop();
            }
        }
    }
}

