/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import org.apache.ftpserver.filesystem.NameEqualsFileFilter;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.WriteRequest;

public class NativeFileObject
implements FileObject {
    private String fileName;
    private File file;
    private User user;

    protected NativeFileObject(String fileName, File file, User user) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can not be null");
        }
        if ((fileName = fileName.trim()).length() == 0) {
            throw new IllegalArgumentException("fileName can not be empty");
        }
        if (fileName.charAt(0) != '/') {
            throw new IllegalArgumentException("fileName must be an absolut path");
        }
        this.fileName = fileName;
        this.file = file;
        this.user = user;
    }

    public String getFullName() {
        String fullName = this.fileName;
        int filelen = fullName.length();
        if (filelen != 1 && fullName.charAt(filelen - 1) == '/') {
            fullName = fullName.substring(0, filelen - 1);
        }
        return fullName;
    }

    public String getShortName() {
        int slashIndex;
        if (this.fileName.equals("/")) {
            return "/";
        }
        String shortName = this.fileName;
        int filelen = this.fileName.length();
        if (shortName.charAt(filelen - 1) == '/') {
            shortName = shortName.substring(0, filelen - 1);
        }
        if ((slashIndex = shortName.lastIndexOf(47)) != -1) {
            shortName = shortName.substring(slashIndex + 1);
        }
        return shortName;
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean doesExist() {
        return this.file.exists();
    }

    public long getSize() {
        return this.file.length();
    }

    public String getOwnerName() {
        return "user";
    }

    public String getGroupName() {
        return "group";
    }

    public int getLinkCount() {
        return this.file.isDirectory() ? 3 : 1;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean hasReadPermission() {
        return this.file.canRead();
    }

    public boolean hasWritePermission() {
        if (this.user.authorize((AuthorizationRequest)new WriteRequest(this.getFullName())) == null) {
            return false;
        }
        if (this.file.exists()) {
            return this.file.canWrite();
        }
        return true;
    }

    public boolean hasDeletePermission() {
        if ("/".equals(this.fileName)) {
            return false;
        }
        return this.hasWritePermission();
    }

    public boolean delete() {
        boolean retVal = false;
        if (this.hasDeletePermission()) {
            retVal = this.file.delete();
        }
        return retVal;
    }

    public boolean move(FileObject dest) {
        boolean retVal = false;
        if (dest.hasWritePermission() && this.hasReadPermission()) {
            File destFile = ((NativeFileObject)dest).file;
            retVal = destFile.exists() ? false : this.file.renameTo(destFile);
        }
        return retVal;
    }

    public boolean mkdir() {
        boolean retVal = false;
        if (this.hasWritePermission()) {
            retVal = this.file.mkdirs();
        }
        return retVal;
    }

    public File getPhysicalFile() {
        return this.file;
    }

    public FileObject[] listFiles() {
        if (!this.file.isDirectory()) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        String virtualFileStr = this.getFullName();
        if (virtualFileStr.charAt(virtualFileStr.length() - 1) != '/') {
            virtualFileStr = virtualFileStr + '/';
        }
        FileObject[] virtualFiles = new FileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            File fileObj = files[i];
            String fileName = virtualFileStr + fileObj.getName();
            virtualFiles[i] = new NativeFileObject(fileName, fileObj, this.user);
        }
        return virtualFiles;
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        if (!this.hasWritePermission()) {
            throw new IOException("No write permission : " + this.file.getName());
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        raf.setLength(offset);
        raf.seek(offset);
        return new FileOutputStream(raf.getFD());
    }

    public InputStream createInputStream(long offset) throws IOException {
        if (!this.hasReadPermission()) {
            throw new IOException("No read permission : " + this.file.getName());
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        raf.seek(offset);
        return new FileInputStream(raf.getFD());
    }

    public static final String normalizeSeparateChar(String pathName) {
        pathName = pathName.replace(File.separatorChar, '/');
        pathName = pathName.replace('\\', '/');
        return pathName;
    }

    public static final String getPhysicalName(String rootDir, String currDir, String fileName) {
        return NativeFileObject.getPhysicalName(rootDir, currDir, fileName, false);
    }

    public static final String getPhysicalName(String rootDir, String currDir, String fileName, boolean caseInsensitive) {
        String resArg;
        rootDir = rootDir.trim();
        fileName = fileName.trim();
        if ((rootDir = NativeFileObject.normalizeSeparateChar(rootDir)).charAt(rootDir.length() - 1) != '/') {
            rootDir = rootDir + '/';
        }
        if ((fileName = NativeFileObject.normalizeSeparateChar(fileName)).charAt(0) != '/') {
            if (currDir == null) {
                currDir = "/";
            }
            if ((currDir = currDir.trim()).length() == 0) {
                currDir = "/";
            }
            if ((currDir = NativeFileObject.normalizeSeparateChar(currDir)).charAt(0) != '/') {
                currDir = '/' + currDir;
            }
            if (currDir.charAt(currDir.length() - 1) != '/') {
                currDir = currDir + '/';
            }
            resArg = rootDir + currDir.substring(1);
        } else {
            resArg = rootDir;
        }
        if (resArg.charAt(resArg.length() - 1) == '/') {
            resArg = resArg.substring(0, resArg.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(fileName, "/");
        while (st.hasMoreTokens()) {
            File[] matches;
            String tok = st.nextToken().trim();
            if (tok.equals(".")) continue;
            if (tok.equals("..")) {
                int slashIndex;
                if (!resArg.startsWith(rootDir) || (slashIndex = resArg.lastIndexOf(47)) == -1) continue;
                resArg = resArg.substring(0, slashIndex);
                continue;
            }
            if (tok.equals("~")) {
                resArg = rootDir.substring(0, rootDir.length() - 1);
                continue;
            }
            if (caseInsensitive && (matches = new File(resArg).listFiles(new NameEqualsFileFilter(tok, true))).length > 0) {
                tok = matches[0].getName();
            }
            resArg = resArg + '/' + tok;
        }
        if (resArg.length() + 1 == rootDir.length()) {
            resArg = resArg + '/';
        }
        if (!resArg.regionMatches(0, rootDir, 0, rootDir.length())) {
            resArg = rootDir;
        }
        return resArg;
    }
}

