/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ftpserver.config.XmlConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConfigurationHandler
extends DefaultHandler {
    private ArrayList elements = new ArrayList();
    private XmlConfiguration root = null;
    private InputSource source = null;
    private StringBuffer elemVal = new StringBuffer(128);

    public XmlConfigurationHandler(InputStream is) {
        this.source = new InputSource(is);
    }

    protected XMLReader getParser() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        return parser.getXMLReader();
    }

    public XmlConfiguration parse() throws Exception {
        if (this.root != null) {
            return this.root;
        }
        XMLReader xmlreader = this.getParser();
        xmlreader.setContentHandler(this);
        xmlreader.setErrorHandler(this);
        xmlreader.parse(this.source);
        return this.root;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.elemVal.append(ch, start, length);
    }

    public void endElement(String uri, String lname, String qname) throws SAXException {
        int location = this.elements.size() - 1;
        XmlConfiguration lastElem = (XmlConfiguration)this.elements.remove(location);
        if (lastElem.getChildCount() == 0) {
            String trimmedElemVal = this.elemVal.toString().trim();
            if (trimmedElemVal.equals("")) {
                lastElem.setValue(null);
            } else {
                lastElem.setValue(trimmedElemVal);
            }
        } else {
            lastElem.setValue(null);
        }
        if (location == 0) {
            this.root = lastElem;
        }
    }

    public void startElement(String uri, String lname, String qname, Attributes attrs) throws SAXException {
        XmlConfiguration element = new XmlConfiguration(qname);
        int lastIdx = this.elements.size() - 1;
        this.elemVal.setLength(0);
        if (lastIdx > -1) {
            XmlConfiguration parent = (XmlConfiguration)this.elements.get(lastIdx);
            parent.setValue(null);
            parent.addChild(element);
        }
        this.elements.add(element);
    }

    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }
}

