/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)RMD.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        FtpletEnum ftpletRet;
        session.resetState();
        FtpServerContext serverContext = connection.getServerContext();
        String fileName = request.getArgument();
        if (fileName == null) {
            out.write(FtpReplyUtil.translate(session, 501, "RMD", null));
            return;
        }
        Ftplet ftpletContainer = serverContext.getFtpletContainer();
        try {
            ftpletRet = ftpletContainer.onRmdirStart((FtpSession)session, request, out);
        }
        catch (Exception e) {
            this.LOG.debug("Ftplet container threw exception", (Throwable)e);
            ftpletRet = FtpletEnum.RET_DISCONNECT;
        }
        if (ftpletRet == FtpletEnum.RET_SKIP) {
            return;
        }
        if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
            serverContext.getConnectionManager().closeConnection(connection);
            return;
        }
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            out.write(FtpReplyUtil.translate(session, 550, "RMD.permission", fileName));
            return;
        }
        fileName = file.getFullName();
        if (!file.hasDeletePermission()) {
            out.write(FtpReplyUtil.translate(session, 550, "RMD.permission", fileName));
            return;
        }
        if (!file.isDirectory()) {
            out.write(FtpReplyUtil.translate(session, 550, "RMD.invalid", fileName));
            return;
        }
        if (file.delete()) {
            out.write(FtpReplyUtil.translate(session, 250, "RMD", fileName));
            String userName = session.getUser().getName();
            this.LOG.info("Directory remove : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)serverContext.getFtpStatistics();
            ftpStat.setRmdir(connection, file);
            try {
                ftpletRet = ftpletContainer.onRmdirEnd((FtpSession)session, request, out);
            }
            catch (Exception e) {
                this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                ftpletRet = FtpletEnum.RET_DISCONNECT;
            }
            if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                serverContext.getConnectionManager().closeConnection(connection);
                return;
            }
        } else {
            out.write(FtpReplyUtil.translate(session, 450, "RMD", fileName));
        }
    }
}

