/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listing.ListArgument;
import org.apache.ftpserver.listing.ListArgumentParser;
import org.apache.ftpserver.listing.MLSTFileFormater;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLST
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)MLST.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException {
        session.resetState();
        ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(parsedArg.getFile());
            if (file != null && file.doesExist()) {
                MLSTFileFormater formater = new MLSTFileFormater((String[])session.getAttribute("MLST.types"));
                out.write(FtpReplyUtil.translate(session, 250, "MLST", formater.format(file)));
            } else {
                out.write(FtpReplyUtil.translate(session, 501, "MLST", null));
            }
        }
        catch (FtpException ex) {
            this.LOG.debug("Exception sending the file listing", (Throwable)ex);
            out.write(FtpReplyUtil.translate(session, 501, "MLST", null));
        }
    }
}

