/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.SocketException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listing.DirectoryLister;
import org.apache.ftpserver.listing.ListArgument;
import org.apache.ftpserver.listing.ListArgumentParser;
import org.apache.ftpserver.listing.MLSTFileFormater;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLSD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)MLSD.class);
    private DirectoryLister directoryLister = new DirectoryLister();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            session.resetState();
            out.write(FtpReplyUtil.translate(session, 150, "MLSD", null));
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the output data stream", (Throwable)e);
                out.write(FtpReplyUtil.translate(session, 425, "MLSD", null));
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            try {
                ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
                MLSTFileFormater formater = new MLSTFileFormater((String[])session.getAttribute("MLST.types"));
                dataConnection.transferToClient(this.directoryLister.listFiles(parsedArg, session.getFileSystemView(), formater));
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                out.write(FtpReplyUtil.translate(session, 426, "MLSD", null));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during data transfer", (Throwable)ex);
                failure = true;
                out.write(FtpReplyUtil.translate(session, 551, "MLSD", null));
            }
            catch (IllegalArgumentException e) {
                this.LOG.debug("Illegal listing syntax: " + request.getArgument(), (Throwable)e);
                out.write(FtpReplyUtil.translate(session, 501, "MLSD", null));
            }
            if (!failure) {
                out.write(FtpReplyUtil.translate(session, 226, "MLSD", null));
            }
        }
        finally {
            session.getDataConnection().closeDataConnection();
        }
    }
}

