/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;

public class TextPlainTextFilter
implements TextFilter {
    public boolean canFilter(String mimeType) {
        return "text/plain".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length == 1) {
            BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            try {
                InputStreamReader reader = encoding == null ? new InputStreamReader(blob.getStream()) : new InputStreamReader(blob.getStream(), encoding);
                HashMap<String, InputStreamReader> result = new HashMap<String, InputStreamReader>();
                result.put(FieldNames.FULLTEXT, reader);
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }
}

