/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Arrays;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.DocOrderNodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.NodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.RowIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultImpl
implements QueryResult {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryResultImpl.class);
    private final ItemManager itemMgr;
    private final ScoreNode[] scoreNodes;
    private final QName[] selectProps;
    private final NamespaceResolver resolver;
    private final boolean docOrder;

    public QueryResultImpl(ItemManager itemMgr, NodeId[] ids, Float[] scores, QName[] selectProps, NamespaceResolver resolver, boolean docOrder) {
        this.scoreNodes = new ScoreNode[ids.length];
        this.itemMgr = itemMgr;
        this.selectProps = selectProps;
        this.resolver = resolver;
        this.docOrder = docOrder;
        for (int i = 0; i < ids.length; ++i) {
            this.scoreNodes[i] = new ScoreNode(ids[i], scores[i].floatValue());
        }
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = NameFormat.format((QName)this.selectProps[i], (NamespaceResolver)this.resolver);
            }
            return propNames;
        }
        catch (NoPrefixDeclaredException npde) {
            String msg = "encountered invalid property name";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, this.resolver);
    }

    private ScoreNodeIterator getNodeIterator() {
        if (this.docOrder) {
            return new DocOrderNodeIteratorImpl(this.itemMgr, Arrays.asList(this.scoreNodes));
        }
        return new NodeIteratorImpl(this.itemMgr, this.scoreNodes);
    }
}

