/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.DocOrderNodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.RowIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyQueryResultImpl
implements QueryResult {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryResultImpl.class);
    private final SearchIndex index;
    private final ItemManager itemMgr;
    protected final NamespaceResolver resolver;
    private final AccessManager accessMgr;
    protected final QueryImpl queryImpl;
    protected final Query query;
    protected final QName[] selectProps;
    protected final QName[] orderProps;
    protected final boolean[] orderSpecs;
    private final List resultNodes = new ArrayList();
    private int numResults = -1;
    private int invalid = 0;
    private final boolean docOrder;

    public LazyQueryResultImpl(SearchIndex index, ItemManager itemMgr, NamespaceResolver resolver, AccessManager accessMgr, QueryImpl queryImpl, Query query, QName[] selectProps, QName[] orderProps, boolean[] orderSpecs, boolean documentOrder) throws RepositoryException {
        this.index = index;
        this.itemMgr = itemMgr;
        this.resolver = resolver;
        this.accessMgr = accessMgr;
        this.queryImpl = queryImpl;
        this.query = query;
        this.selectProps = selectProps;
        this.orderProps = orderProps;
        this.orderSpecs = orderSpecs;
        this.docOrder = orderProps.length == 0 && documentOrder;
        this.getResults(this.docOrder ? Integer.MAX_VALUE : index.getResultFetchSize());
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = NameFormat.format((QName)this.selectProps[i], (NamespaceResolver)this.resolver);
            }
            return propNames;
        }
        catch (NoPrefixDeclaredException npde) {
            String msg = "encountered invalid property name";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, this.resolver);
    }

    protected QueryHits executeQuery() throws IOException {
        return this.index.executeQuery(this.queryImpl, this.query, this.orderProps, this.orderSpecs);
    }

    private ScoreNodeIterator getNodeIterator() {
        if (this.docOrder) {
            return new DocOrderNodeIteratorImpl(this.itemMgr, this.resultNodes);
        }
        return new LazyScoreNodeIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResults(int size) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("getResults(" + size + ")");
        }
        if (this.resultNodes.size() >= size) {
            return;
        }
        QueryHits result = null;
        try {
            result = this.executeQuery();
            if (this.numResults == -1) {
                this.numResults = result.length();
            }
            int start = this.resultNodes.size() + this.invalid;
            int max = Math.min(result.length(), this.numResults);
            for (int i = start; i < max && this.resultNodes.size() < size; ++i) {
                NodeId id = NodeId.valueOf(result.doc(i).get(FieldNames.UUID));
                try {
                    if (!this.accessMgr.isGranted(id, 1)) continue;
                    this.resultNodes.add(new ScoreNode(id, result.score(i)));
                    continue;
                }
                catch (ItemNotFoundException e) {
                    ++this.invalid;
                }
            }
        }
        catch (IOException e) {
            log.error("Exception while executing query: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close query result: " + e);
                }
            }
        }
    }

    private final class LazyScoreNodeIterator
    implements ScoreNodeIterator {
        private int position = -1;
        private boolean initialized = false;
        private NodeImpl next;

        private LazyScoreNodeIterator() {
        }

        public float getScore() {
            this.initialize();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ((ScoreNode)LazyQueryResultImpl.this.resultNodes.get(this.position)).getScore();
        }

        public NodeImpl nextNodeImpl() {
            this.initialize();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            NodeImpl n = this.next;
            this.fetchNext();
            return n;
        }

        public Node nextNode() {
            return this.nextNodeImpl();
        }

        public void skip(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if ((long)(this.position + LazyQueryResultImpl.this.invalid) + skipNum > (long)LazyQueryResultImpl.this.numResults) {
                throw new NoSuchElementException();
            }
            if (skipNum != 0L) {
                try {
                    LazyQueryResultImpl.this.getResults(this.position + LazyQueryResultImpl.this.invalid + (int)skipNum);
                    if ((long)LazyQueryResultImpl.this.resultNodes.size() < (long)this.position + skipNum) {
                        throw new NoSuchElementException();
                    }
                    this.position = (int)((long)this.position + (skipNum - 1L));
                    this.fetchNext();
                }
                catch (RepositoryException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
        }

        public long getSize() {
            return LazyQueryResultImpl.this.numResults - LazyQueryResultImpl.this.invalid;
        }

        public long getPosition() {
            this.initialize();
            return this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.initialize();
            return this.next != null;
        }

        public Object next() {
            return this.nextNodeImpl();
        }

        private void initialize() {
            if (!this.initialized) {
                this.fetchNext();
                this.initialized = true;
            }
        }

        private void fetchNext() {
            this.next = null;
            int nextPos = this.position + 1;
            while (this.next == null && nextPos + LazyQueryResultImpl.this.invalid < LazyQueryResultImpl.this.numResults) {
                if (nextPos >= LazyQueryResultImpl.this.resultNodes.size()) {
                    try {
                        int num = LazyQueryResultImpl.this.resultNodes.size() == 0 ? LazyQueryResultImpl.this.index.getResultFetchSize() : LazyQueryResultImpl.this.resultNodes.size() * 2;
                        LazyQueryResultImpl.this.getResults(num);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception getting more results: " + (Object)((Object)e));
                    }
                    if (nextPos >= LazyQueryResultImpl.this.resultNodes.size()) {
                        return;
                    }
                }
                ScoreNode sn = (ScoreNode)LazyQueryResultImpl.this.resultNodes.get(nextPos);
                try {
                    this.next = (NodeImpl)LazyQueryResultImpl.this.itemMgr.getItem(sn.getNodeId());
                }
                catch (RepositoryException e) {
                    log.warn("Exception retrieving Node with UUID: " + sn.getNodeId() + ": " + e.toString());
                    LazyQueryResultImpl.this.resultNodes.remove(nextPos);
                    LazyQueryResultImpl.this.invalid++;
                }
            }
            ++this.position;
        }
    }
}

