/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

abstract class DocId {
    static final DocId NULL = new DocId(){

        final int getDocumentNumber(IndexReader reader) {
            return -1;
        }

        final DocId applyOffset(int offset) {
            return this;
        }

        final boolean isValid(BitSet deleted) {
            return true;
        }
    };

    DocId() {
    }

    abstract int getDocumentNumber(IndexReader var1) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        return new PlainDocId(docNumber);
    }

    static DocId create(String uuid) {
        return new UUIDDocId(uuid);
    }

    private static final class UUIDDocId
    extends DocId {
        private final String uuid;
        private Reference reader;
        private int docNumber;

        UUIDDocId(String uuid) {
            this.uuid = uuid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getDocumentNumber(IndexReader reader) throws IOException {
            UUIDDocId uUIDDocId = this;
            synchronized (uUIDDocId) {
                if (this.reader != null && this.reader.get() == reader) {
                    return this.docNumber;
                }
            }
            Term id = new Term(FieldNames.UUID, this.uuid);
            TermDocs docs = reader.termDocs(id);
            int doc = -1;
            try {
                if (docs.next()) {
                    doc = docs.doc();
                }
            }
            finally {
                docs.close();
            }
            UUIDDocId uUIDDocId2 = this;
            synchronized (uUIDDocId2) {
                this.docNumber = doc;
                this.reader = new WeakReference<IndexReader>(reader);
            }
            return doc;
        }

        DocId applyOffset(int offset) {
            return this;
        }

        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            return "UUIDDocId(" + this.uuid + ")";
        }
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        int getDocumentNumber(IndexReader reader) {
            return this.docNumber;
        }

        DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }
}

