/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.name.QName;

public class OrderQueryNode
extends QueryNode {
    private final List specs = new ArrayList();

    public OrderQueryNode(QueryNode parent) {
        super(parent);
    }

    public int getType() {
        return 3;
    }

    public void addOrderSpec(QName property, boolean ascending) {
        this.specs.add(new OrderSpec(property, ascending));
    }

    public void addOrderSpec(OrderSpec spec) {
        this.specs.add(spec);
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isAscending(int i) throws IndexOutOfBoundsException {
        return ((OrderSpec)this.specs.get(i)).ascending;
    }

    public OrderSpec[] getOrderSpecs() {
        return this.specs.toArray(new OrderSpec[this.specs.size()]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrderQueryNode) {
            OrderQueryNode other = (OrderQueryNode)obj;
            return ((Object)this.specs).equals(other.specs);
        }
        return false;
    }

    public static final class OrderSpec {
        private QName property;
        private boolean ascending;

        public OrderSpec(QName property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public QName getProperty() {
            return this.property;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OrderSpec) {
                OrderSpec other = (OrderSpec)obj;
                return (this.property == null ? other.property == null : this.property.equals((Object)other.property)) && this.ascending == other.ascending;
            }
            return false;
        }
    }
}

