/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.cluster.ItemOperation;
import org.apache.jackrabbit.core.cluster.PropertyAddedOperation;
import org.apache.jackrabbit.core.cluster.PropertyDeletedOperation;
import org.apache.jackrabbit.core.cluster.PropertyModifiedOperation;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.value.InternalValue;

abstract class PropertyOperation
extends ItemOperation {
    private PropDefId definitionId;
    private PropertyId id;
    private Boolean multiValued;
    private Integer type;
    private InternalValue[] values;

    protected PropertyOperation(int operationType) {
        super(operationType);
    }

    public static PropertyOperation create(int operationType) {
        switch (operationType) {
            case 1: {
                return new PropertyAddedOperation();
            }
            case 2: {
                return new PropertyModifiedOperation();
            }
            case 3: {
                return new PropertyDeletedOperation();
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + operationType);
    }

    public boolean hasDefinitionId() {
        return this.definitionId != null;
    }

    public PropDefId getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(PropDefId definitionId) {
        this.definitionId = definitionId;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public PropertyId getId() {
        return this.id;
    }

    public void setId(PropertyId id) {
        this.id = id;
    }

    public boolean hasMultiValued() {
        return this.multiValued != null;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = new Boolean(multiValued);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = new Integer(type);
    }

    public boolean hasValues() {
        return this.values != null;
    }

    public InternalValue[] getValues() {
        return this.values;
    }

    public void setValues(InternalValue[] values) {
        this.values = values;
    }
}

