/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.List;
import java.util.Map;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleRuntime;
import javax.rules.RuleSession;
import javax.rules.RuleSessionCreateException;
import javax.rules.RuleSessionTypeUnsupportedException;
import org.drools.jsr94.rules.StatefulRuleSessionImpl;
import org.drools.jsr94.rules.StatelessRuleSessionImpl;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepository;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepositoryException;

public class RuleRuntimeImpl
implements RuleRuntime {
    private static final long serialVersionUID = 400L;
    private RuleExecutionSetRepository repository;

    public RuleRuntimeImpl(RuleExecutionSetRepository repository) {
        this.repository = repository;
    }

    public RuleSession createRuleSession(String uri, Map properties, int ruleSessionType) throws RuleSessionTypeUnsupportedException, RuleSessionCreateException, RuleExecutionSetNotFoundException {
        if (ruleSessionType == 1) {
            StatelessRuleSessionImpl session = new StatelessRuleSessionImpl(uri, properties, this.repository);
            return session;
        }
        if (ruleSessionType == 0) {
            StatefulRuleSessionImpl session = new StatefulRuleSessionImpl(uri, properties, this.repository);
            return session;
        }
        throw new RuleSessionTypeUnsupportedException("invalid session type: " + ruleSessionType);
    }

    public List getRegistrations() {
        try {
            return this.repository.getRegistrations();
        }
        catch (RuleExecutionSetRepositoryException e) {
            String s = "Error while retrieving list of registrations";
            throw new RuntimeException(s, (Throwable)((Object)e));
        }
    }
}

