/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.stats;

import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.stats.StatsListener;
import com.sun.identity.shared.stats.StatsRunner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Stats
implements ShutdownListener {
    public static final int OFF = 0;
    public static final int FILE = 1;
    public static final int CONSOLE = 2;
    private static Map statsMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static DateFormat dateFormat;
    private static String defaultStatsLevel;
    private static String outputDirectory;
    private final String statsName;
    private PrintWriter statsFile = null;
    private int statsState;
    private static StatsRunner statsListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initService() {
        if (!serviceInitialized) {
            Class clazz = Stats.class;
            synchronized (clazz) {
                if (!serviceInitialized) {
                    dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
                    try {
                        File createDir;
                        defaultStatsLevel = SystemPropertiesManager.get("com.iplanet.services.stats.state");
                        outputDirectory = SystemPropertiesManager.get("com.iplanet.services.stats.directory");
                        ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                        if (outputDirectory != null && !(createDir = new File(outputDirectory)).exists() && !createDir.mkdirs()) {
                            System.err.println(bundle.getString("com.iplanet.services.stats.nodir"));
                        }
                    }
                    catch (MissingResourceException e) {
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                        defaultStatsLevel = "console";
                        outputDirectory = null;
                    }
                    catch (SecurityException se) {
                        System.err.println(se.getMessage());
                    }
                    SystemTimer.getTimer().schedule((TaskRunnable)statsListeners, new Date((System.currentTimeMillis() + statsListeners.getRunPeriod()) / 1000L * 1000L));
                    serviceInitialized = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stats(String statsName) {
        Stats.initService();
        this.statsName = statsName;
        this.setStats(defaultStatsLevel);
        Map map = statsMap;
        synchronized (map) {
            statsMap.put(statsName, this);
        }
        ShutdownManager.getInstance().addShutdownListener(this);
    }

    public static synchronized Stats getInstance(String statsName) {
        Stats statsObj = (Stats)statsMap.get(statsName);
        if (statsObj == null) {
            statsObj = new Stats(statsName);
        }
        return statsObj;
    }

    public boolean isEnabled() {
        return this.statsState > 0;
    }

    public int getState() {
        return this.statsState;
    }

    public void record(String msg) {
        if (this.statsState > 0) {
            this.formatAndWrite(null, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatAndWrite(String prefix, String msg) {
        if (this.statsState == 2) {
            if (msg != null) {
                if (prefix == null) {
                    System.out.println(msg);
                } else {
                    System.out.println(prefix + msg);
                }
            }
            return;
        }
        String serverInstance = System.getProperty("server.name");
        StringWriter swriter = new StringWriter(160);
        PrintWriter buf = new PrintWriter((Writer)swriter, true);
        DateFormat dateFormat = Stats.dateFormat;
        synchronized (dateFormat) {
            buf.write(Stats.dateFormat.format(new Date()));
        }
        if (serverInstance != null && serverInstance != "") {
            buf.write(": ");
            buf.write("Server Instance: " + serverInstance);
        }
        buf.write(": ");
        buf.write(Thread.currentThread().toString());
        buf.write("\n");
        if (prefix != null) {
            buf.write(prefix);
        }
        if (msg != null) {
            buf.write(msg);
        }
        buf.flush();
        this.write(swriter.toString());
    }

    private synchronized void write(String msg) {
        try {
            if (this.statsFile == null) {
                FileOutputStream fos = new FileOutputStream(outputDirectory + File.separator + this.statsName, true);
                this.statsFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")), true);
                this.statsFile.println("******************************************************");
            }
            this.statsFile.println(msg);
        }
        catch (IOException e) {
            System.err.println(msg);
            this.statsState = 0;
        }
    }

    public void setStats(int statsType) {
        switch (statsType) {
            case 0: 
            case 1: 
            case 2: {
                this.statsState = statsType;
                break;
            }
        }
    }

    public void setStats(String statsType) {
        if (statsType == null) {
            return;
        }
        if (statsType.equalsIgnoreCase("console")) {
            this.statsState = 2;
        } else if (statsType.equalsIgnoreCase("file")) {
            this.statsState = 1;
        } else if (statsType.equalsIgnoreCase("off")) {
            this.statsState = 0;
        } else if (statsType.equals("*")) {
            this.statsState = 2;
        } else {
            if (statsType.endsWith("*")) {
                statsType = statsType.substring(0, statsType.length() - 1);
            }
            if (this.statsName.startsWith(statsType)) {
                this.statsState = 2;
            }
        }
    }

    public void destroy() {
        this.finalize();
    }

    public void shutdown() {
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Object object = statsMap;
        synchronized (object) {
            statsMap.remove(this.statsName);
        }
        object = this;
        synchronized (object) {
            if (this.statsFile == null) {
                return;
            }
            this.statsState = 0;
            this.statsFile.flush();
            this.statsFile.close();
            this.statsFile = null;
        }
    }

    public void addStatsListener(StatsListener listener) {
        statsListeners.addElement(listener);
    }

    static {
        statsListeners = new StatsRunner();
    }
}

