/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.HeadTaskRunnable;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.Triggerable;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class TimerPool
implements Triggerable {
    private int poolSize;
    private String name;
    private int busyThreadCount;
    private int currentThreadCount;
    private volatile boolean shutdownThePool;
    private boolean daemon;
    private WorkerThread[] threads;
    private Scheduler scheduler;
    private SortedMap taskList;
    private Date nextRun;
    private Debug debug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerPool(String name, int poolSize, boolean daemon, Debug debug) {
        this.name = name;
        this.poolSize = poolSize;
        this.busyThreadCount = 0;
        this.currentThreadCount = 0;
        this.daemon = daemon;
        this.debug = debug;
        this.shutdownThePool = false;
        this.threads = new WorkerThread[poolSize];
        this.scheduler = new Scheduler(this);
        this.scheduler.start();
        this.taskList = Collections.synchronizedSortedMap(new TreeMap());
        TimerPool timerPool = this;
        synchronized (timerPool) {
            this.createThreads(poolSize);
        }
    }

    private void createThreads(int timersToCreate) {
        if (timersToCreate > this.poolSize) {
            timersToCreate = this.poolSize;
        }
        for (int i = this.currentThreadCount; i < timersToCreate; ++i) {
            this.threads[i - this.busyThreadCount] = new WorkerThread(this.name, this);
            this.threads[i - this.busyThreadCount].setDaemon(this.daemon);
            this.threads[i - this.busyThreadCount].start();
        }
        this.currentThreadCount = timersToCreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerThread getAvailableThread() {
        WorkerThread t = null;
        TimerPool timerPool = this;
        synchronized (timerPool) {
            if (this.currentThreadCount == this.busyThreadCount) {
                this.createThreads(this.poolSize);
            }
            t = this.threads[this.currentThreadCount - this.busyThreadCount - 1];
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = null;
            ++this.busyThreadCount;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNext() {
        WorkerThread t = null;
        HeadTaskRunnable task = null;
        TimerPool timerPool = this;
        synchronized (timerPool) {
            if (this.shutdownThePool) {
                return;
            }
            while (this.busyThreadCount == this.poolSize) {
                try {
                    this.wait();
                    if (!this.shutdownThePool) continue;
                    return;
                }
                catch (Exception ex) {
                    if (this.debug == null) continue;
                    this.debug.error("TimerPool:runNext() " + this.name, ex);
                }
            }
            if (this.nextRun != null) {
                long now = System.currentTimeMillis();
                if (this.nextRun.getTime() <= now && (task = (HeadTaskRunnable)this.taskList.remove(this.nextRun)) != null) {
                    t = this.getAvailableThread();
                }
                try {
                    this.nextRun = (Date)this.taskList.firstKey();
                    long delay = this.nextRun.getTime() - now;
                    this.scheduler.setDelay(delay >= 0L ? delay : 0L);
                }
                catch (NoSuchElementException ex) {
                    this.nextRun = null;
                    this.scheduler.setDelay(-1L);
                }
            }
        }
        if (t != null && task != null) {
            t.runTask(task);
        }
    }

    private synchronized void deductCurrentThreadCount() {
        --this.currentThreadCount;
        --this.busyThreadCount;
        this.notify();
    }

    private synchronized void replaceScheduler() {
        this.scheduler.terminate();
        this.scheduler = new Scheduler(this);
        this.scheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnThread(WorkerThread t) {
        if (this.shutdownThePool) {
            t.terminate();
            TimerPool timerPool = this;
            synchronized (timerPool) {
                --this.busyThreadCount;
                if (this.busyThreadCount == 0) {
                    this.notifyAll();
                }
            }
        }
        TimerPool timerPool = this;
        synchronized (timerPool) {
            --this.busyThreadCount;
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = t;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TaskRunnable task, Date time) throws IllegalArgumentException, IllegalStateException {
        if (this.shutdownThePool) {
            throw new IllegalStateException("The timers have been shuted down!");
        }
        if (task != null && time != null) {
            HeadTaskRunnable head = null;
            do {
                if ((head = task.getHeadTask()) == null || !head.acquireValidLock()) continue;
                try {
                    if (head == task.getHeadTask()) {
                        if (head.scheduledExecutionTime() == time.getTime()) {
                            return;
                        }
                        if (!head.isTimedOut()) {
                            throw new IllegalStateException("The task has been scheduled!");
                        }
                    }
                }
                finally {
                    head.releaseLockAndNotify();
                }
            } while (head != task.getHeadTask());
            Object object = this.taskList;
            synchronized (object) {
                head = (HeadTaskRunnable)this.taskList.get(time);
                if (head == null) {
                    task.setNext(null);
                    this.taskList.put(time, new HeadTaskRunnable(this, task, time));
                }
            }
            if (head == null) {
                object = this;
                synchronized (object) {
                    if (this.nextRun == null || time.getTime() < this.nextRun.getTime()) {
                        this.nextRun = time;
                        long delay = time.getTime() - System.currentTimeMillis();
                        this.scheduler.setWait(delay < 0L ? 0L : delay);
                    }
                }
            } else if (head.acquireValidLock()) {
                try {
                    task.setHeadTask(head);
                    TaskRunnable tailTask = head.tail();
                    task.setPrevious(tailTask);
                    tailTask.setNext(task);
                    task.setNext(null);
                    head.setTail(task);
                }
                finally {
                    head.releaseLockAndNotify();
                }
            } else {
                this.schedule(task, time);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void schedule(TaskRunnable task, long delay) throws IllegalArgumentException, IllegalStateException {
        this.schedule(task, new Date(System.currentTimeMillis() + delay));
    }

    public void trigger(Date time) {
        this.taskList.remove(time);
    }

    public synchronized void shutdown() {
        if (!this.shutdownThePool) {
            this.shutdownThePool = true;
            this.scheduler.terminate();
            for (int i = 0; i < this.currentThreadCount - this.busyThreadCount; ++i) {
                this.threads[i].terminate();
            }
            while (this.busyThreadCount != 0) {
                try {
                    this.wait();
                }
                catch (Exception ex) {
                    if (this.debug == null) continue;
                    this.debug.error("TimerPool:shutdown() " + this.name, ex);
                }
            }
            this.busyThreadCount = 0;
            this.currentThreadCount = 0;
            this.threads = null;
        }
    }

    private class Scheduler
    extends Thread {
        private volatile boolean shouldTerminate = false;
        private boolean beingNotified = false;
        private long delay = -1L;
        private TimerPool pool;

        public Scheduler(TimerPool pool) {
            this.pool = pool;
            this.setName(pool.name + "-Scheduler");
        }

        public synchronized void setWait(long delay) {
            this.delay = delay;
            this.beingNotified = true;
            this.notify();
        }

        public synchronized void setDelay(long delay) {
            this.delay = delay;
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            long localDelay = -1L;
            do {
                try {
                    while (true) {
                        Scheduler scheduler = this;
                        // MONITORENTER : scheduler
                        if (this.shouldTerminate) break;
                        if (this.delay > 0L) {
                            this.wait(this.delay);
                            if (!this.beingNotified) break;
                            this.beingNotified = false;
                            // MONITOREXIT : scheduler
                            continue;
                        }
                        if (this.delay >= 0L) break;
                        this.wait();
                        if (!this.beingNotified) break;
                        this.beingNotified = false;
                        // MONITOREXIT : scheduler
                    }
                    // MONITOREXIT : scheduler
                    if (this.shouldTerminate) {
                        return;
                    }
                    this.pool.runNext();
                }
                catch (RuntimeException ex) {
                    this.pool.replaceScheduler();
                }
                catch (Exception ex) {
                }
                catch (Throwable t) {
                    this.pool.replaceScheduler();
                    throw new Error(t);
                }
            } while (!this.shouldTerminate);
        }
    }

    private class WorkerThread
    extends Thread {
        private TimerPool pool;
        private HeadTaskRunnable task;
        private volatile boolean shouldTerminate;
        private volatile boolean needReturn;

        public WorkerThread(String name, TimerPool pool) {
            this.setName(name);
            this.pool = pool;
            this.shouldTerminate = false;
            this.needReturn = true;
            this.task = null;
        }

        public synchronized void runTask(HeadTaskRunnable toRun) {
            this.task = toRun;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.needReturn = false;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HeadTaskRunnable localHeadTask = null;
            TaskRunnable localTask = null;
            TaskRunnable runTask = null;
            WorkerThread t = this;
            do {
                WorkerThread thread;
                try {
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (!this.shouldTerminate && this.task == null) {
                            this.wait();
                        }
                        localHeadTask = this.task;
                        this.task = null;
                    }
                    if (!this.shouldTerminate) {
                        if (localHeadTask == null || !localHeadTask.acquireValidLock()) continue;
                        try {
                            localHeadTask.timeout();
                            localTask = localHeadTask.next();
                            do {
                                runTask = localTask;
                                localTask = localTask.next();
                                runTask.setNext(null);
                                runTask.run();
                                if (runTask.getRunPeriod() < 0L) continue;
                                this.pool.schedule(runTask, new Date(localHeadTask.scheduledExecutionTime() + runTask.getRunPeriod()));
                            } while (localTask != null);
                            localHeadTask.expire();
                            continue;
                        }
                        finally {
                            localHeadTask.releaseLockAndNotify();
                        }
                    }
                    break;
                }
                catch (IllegalStateException ex) {
                    if (TimerPool.this.debug != null) {
                        TimerPool.this.debug.message("TimerPool$WorkerThread:run() " + TimerPool.this.name, ex);
                    }
                    this.shouldTerminate = true;
                }
                catch (RuntimeException ex) {
                    if (TimerPool.this.debug != null) {
                        TimerPool.this.debug.error("TimerPool$WorkerThread:run() " + TimerPool.this.name, ex);
                    }
                    if (localHeadTask != null && localHeadTask.acquireValidLock()) {
                        try {
                            if (runTask.getRunPeriod() >= 0L && runTask.scheduledExecutionTime() == localHeadTask.scheduledExecutionTime()) {
                                this.pool.schedule(runTask, new Date(localHeadTask.scheduledExecutionTime() + runTask.getRunPeriod()));
                            }
                            if (localTask != null) {
                                localHeadTask.setNext(localTask);
                                localTask.setPrevious(localHeadTask);
                            }
                        }
                        catch (IllegalStateException iex) {
                            if (TimerPool.this.debug != null) {
                                TimerPool.this.debug.message("TimerPool$WorkerThread:run() " + TimerPool.this.name, iex);
                            }
                            this.shouldTerminate = true;
                        }
                        finally {
                            localHeadTask.releaseLockAndNotify();
                        }
                    }
                    TimerPool iex = this.pool;
                    synchronized (iex) {
                        this.pool.deductCurrentThreadCount();
                        if (localTask != null) {
                            thread = this.pool.getAvailableThread();
                            thread.runTask(localHeadTask);
                        }
                    }
                    this.shouldTerminate = true;
                    this.needReturn = false;
                }
                catch (Exception ex) {
                    if (TimerPool.this.debug == null) continue;
                    TimerPool.this.debug.error("TimerPool$WorkerThread:run() " + TimerPool.this.name, ex);
                }
                catch (Throwable e) {
                    if (TimerPool.this.debug != null) {
                        TimerPool.this.debug.error("TimerPool$WorkerThread:run() " + TimerPool.this.name, e);
                    }
                    if (localHeadTask != null && localHeadTask.acquireValidLock()) {
                        try {
                            if (runTask.getRunPeriod() >= 0L && runTask.scheduledExecutionTime() == localHeadTask.scheduledExecutionTime()) {
                                this.pool.schedule(runTask, new Date(localHeadTask.scheduledExecutionTime() + runTask.getRunPeriod()));
                            }
                            if (localTask != null) {
                                localHeadTask.setNext(localTask);
                                localTask.setPrevious(localHeadTask);
                            }
                        }
                        catch (IllegalStateException iex) {
                            if (TimerPool.this.debug != null) {
                                TimerPool.this.debug.message("TimerPool$WorkerThread:run() " + TimerPool.this.name, iex);
                            }
                            this.shouldTerminate = true;
                        }
                        finally {
                            localHeadTask.releaseLockAndNotify();
                        }
                    }
                    TimerPool timerPool = this.pool;
                    synchronized (timerPool) {
                        this.pool.deductCurrentThreadCount();
                        if (localTask != null) {
                            thread = this.pool.getAvailableThread();
                            thread.runTask(localHeadTask);
                        }
                    }
                    this.shouldTerminate = true;
                    this.needReturn = false;
                    throw new Error(e);
                }
                finally {
                    localHeadTask = null;
                    localTask = null;
                    if (this.needReturn) {
                        this.pool.returnThread(t);
                    }
                }
            } while (!this.shouldTerminate);
        }
    }
}

