/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class GenericValueConverter
implements AVAValueConverter {
    private static byte[] DefEncodingTags = new byte[]{19, 22, 30, 12, 20, 28};

    public DerValue getValue(String s) throws IOException {
        return this.getValue(s, null);
    }

    public DerValue getValue(String s, byte[] tags) throws IOException {
        int i;
        int ret = -1;
        if (tags == null || tags.length == 0) {
            tags = DefEncodingTags;
        }
        byte[] bbuf = new byte[4 * s.length()];
        for (i = 0; i < tags.length; ++i) {
            try {
                CharToByteConverter cbc = ASN1CharStrConvMap.getDefault().getCBC(tags[i]);
                if (cbc == null) continue;
                ret = cbc.convert(s.toCharArray(), 0, s.length(), bbuf, 0, bbuf.length);
                break;
            }
            catch (CharConversionException e) {
                continue;
            }
            catch (InstantiationException e) {
                throw new IOException("Cannot instantiate CharToByteConverter");
            }
            catch (IllegalAccessException e) {
                throw new IOException("Illegal Access loading CharToByteConverter");
            }
        }
        if (ret == -1) {
            throw new IllegalArgumentException("Cannot convert the string value to a ASN.1 type");
        }
        byte[] derBuf = new byte[ret];
        System.arraycopy(bbuf, 0, derBuf, 0, ret);
        return new DerValue(tags[i], derBuf);
    }

    public DerValue getValue(byte[] berByteStream) throws IOException {
        DerValue value = new DerValue(berByteStream);
        return value;
    }

    public String getAsString(DerValue avaValue) throws IOException {
        return avaValue.getASN1CharString();
    }
}

