/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.ListIterator;
import sun.net.httpserver.ServerConfig;

public class SelectorCache {
    static SelectorCache cache = null;
    LinkedList<SelectorWrapper> freeSelectors = new LinkedList();

    private SelectorCache() {
        CacheCleaner cacheCleaner = AccessController.doPrivileged(new PrivilegedAction<CacheCleaner>(){

            @Override
            public CacheCleaner run() {
                CacheCleaner cacheCleaner = new CacheCleaner();
                cacheCleaner.setDaemon(true);
                return cacheCleaner;
            }
        });
        cacheCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorCache getSelectorCache() {
        Class<SelectorCache> clazz = SelectorCache.class;
        synchronized (SelectorCache.class) {
            if (cache == null) {
                cache = new SelectorCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    synchronized Selector getSelector() throws IOException {
        Selector selector;
        SelectorWrapper selectorWrapper = null;
        if (this.freeSelectors.size() > 0) {
            selectorWrapper = this.freeSelectors.remove();
            selector = selectorWrapper.getSelector();
        } else {
            selector = Selector.open();
        }
        return selector;
    }

    synchronized void freeSelector(Selector selector) {
        this.freeSelectors.add(new SelectorWrapper(selector));
    }

    class CacheCleaner
    extends Thread {
        CacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = ServerConfig.getSelCacheTimeout() * 1000L;
            while (true) {
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LinkedList<SelectorWrapper> linkedList = SelectorCache.this.freeSelectors;
                synchronized (linkedList) {
                    ListIterator listIterator = SelectorCache.this.freeSelectors.listIterator();
                    while (listIterator.hasNext()) {
                        SelectorWrapper selectorWrapper = (SelectorWrapper)listIterator.next();
                        if (selectorWrapper.getDeleteFlag()) {
                            try {
                                selectorWrapper.getSelector().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            listIterator.remove();
                            continue;
                        }
                        selectorWrapper.setDeleteFlag(true);
                    }
                }
            }
        }
    }

    private static class SelectorWrapper {
        private Selector sel;
        private boolean deleteFlag;

        private SelectorWrapper(Selector selector) {
            this.sel = selector;
            this.deleteFlag = false;
        }

        public Selector getSelector() {
            return this.sel;
        }

        public boolean getDeleteFlag() {
            return this.deleteFlag;
        }

        public void setDeleteFlag(boolean bl) {
            this.deleteFlag = bl;
        }
    }
}

