/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl.client;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.provider.wsit.WSITClientAuthContext;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class DefaultSCTokenConfiguration
extends SCTokenConfiguration {
    private static final String SC_CLIENT_CONFIGURATION = "SCClientConfiguration";
    private static final String RENEW_EXPIRED_SCT = "renewExpiredSCT";
    private static final String REQUIRE_CANCEL_SCT = "requireCancelSCT";
    private static final String LIFETIME = "LifeTime";
    private static final String CONFIG_NAMESPACE = "";
    private Trust10 trust10 = null;
    private Trust13 trust13 = null;
    private SymmetricBinding symBinding = null;
    private int skl = 0;
    private boolean reqClientEntropy = true;
    private boolean isExpired = false;
    private boolean checkTokenExpiry = true;
    private boolean clientOutboundMessage = true;
    private WSDLPort wsdlPort = null;
    private WSBinding wsBinding = null;
    private Pipe clientSecurityPipe = null;
    private Packet packet = null;
    private WSITClientAuthContext wsitClientAuthContext = null;
    private AddressingVersion addVer = null;
    private Token scToken = null;
    private String tokenId = null;
    private MessagePolicy messagePolicy = null;
    private boolean addRenewPolicy = true;

    public DefaultSCTokenConfiguration(String protocol, SecureConversationToken scToken, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, Packet packet, AddressingVersion addVer, PolicyAssertion localToken) {
        this.protocol = protocol;
        this.scToken = scToken;
        this.wsdlPort = wsdlPort;
        this.wsBinding = binding;
        this.clientSecurityPipe = securityPipe;
        this.packet = packet;
        this.addVer = addVer;
        this.tokenId = scToken.getTokenId();
        this.parseAssertions(scToken, localToken);
    }

    public DefaultSCTokenConfiguration(String protocol, SecureConversationToken scToken, WSDLPort wsdlPort, WSBinding binding, WSITClientAuthContext wsitClientAuthContext, Packet packet, AddressingVersion addVer, PolicyAssertion localToken) {
        this.protocol = protocol;
        this.scToken = scToken;
        this.wsdlPort = wsdlPort;
        this.wsBinding = binding;
        this.wsitClientAuthContext = wsitClientAuthContext;
        this.packet = packet;
        this.addVer = addVer;
        this.tokenId = scToken.getTokenId();
        this.parseAssertions(scToken, localToken);
    }

    public DefaultSCTokenConfiguration(String protocol, MessagePolicy messagePolicy) {
        super(protocol);
        this.messagePolicy = messagePolicy;
    }

    public DefaultSCTokenConfiguration(String protocol, MessagePolicy messagePolicy, boolean addRenewPolicy) {
        this(protocol, messagePolicy);
        this.addRenewPolicy = addRenewPolicy;
    }

    public DefaultSCTokenConfiguration(String protocol, String tokenId, boolean checkTokenExpiry) {
        super(protocol);
        this.tokenId = tokenId;
        this.checkTokenExpiry = checkTokenExpiry;
    }

    public DefaultSCTokenConfiguration(String protocol, String tokenId, boolean checkTokenExpiry, boolean clientOutboundMessage) {
        this(protocol, tokenId, checkTokenExpiry);
        this.clientOutboundMessage = clientOutboundMessage;
    }

    private void parseAssertions(SecureConversationToken scToken, PolicyAssertion localToken) {
        Set trustReqdProps;
        AssertionSet assertions = scToken.getBootstrapPolicy().getAssertionSet();
        for (PolicyAssertion policyAssertion : assertions) {
            SecurityPolicyVersion spVersion;
            if (PolicyUtil.isTrust13(policyAssertion, spVersion = PolicyUtil.getSecurityPolicyVersion(policyAssertion.getName().getNamespaceURI()))) {
                this.trust13 = (Trust13)policyAssertion;
                continue;
            }
            if (PolicyUtil.isTrust10(policyAssertion, spVersion)) {
                this.trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding(policyAssertion, spVersion)) continue;
            this.symBinding = (SymmetricBinding)((Object)policyAssertion);
        }
        if (this.symBinding != null) {
            AlgorithmSuite algoSuite = this.symBinding.getAlgorithmSuite();
            this.skl = algoSuite.getMinSKLAlgorithm();
        }
        if (this.trust10 != null) {
            trustReqdProps = this.trust10.getRequiredProperties();
            this.reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        if (this.trust13 != null) {
            trustReqdProps = this.trust13.getRequiredProperties();
            this.reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        if (localToken != null) {
            if (SC_CLIENT_CONFIGURATION.equals(localToken.getName().getLocalPart())) {
                Map<QName, String> attrs = localToken.getAttributes();
                this.renewExpiredSCT = Boolean.parseBoolean(attrs.get(new QName(CONFIG_NAMESPACE, RENEW_EXPIRED_SCT)));
                this.requireCancelSCT = Boolean.parseBoolean(attrs.get(new QName(CONFIG_NAMESPACE, REQUIRE_CANCEL_SCT)));
            }
            Iterator<PolicyAssertion> sctConfig = localToken.getNestedAssertionsIterator();
            while (sctConfig.hasNext()) {
                PolicyAssertion sctConfigPolicy = sctConfig.next();
                if (!LIFETIME.equals(sctConfigPolicy.getName().getLocalPart())) continue;
                this.scTokenTimeout = Integer.parseInt(sctConfigPolicy.getValue());
                break;
            }
        }
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public boolean checkTokenExpiry() {
        return this.checkTokenExpiry;
    }

    public boolean isClientOutboundMessage() {
        return this.clientOutboundMessage;
    }

    public MessagePolicy getMessagePolicy() {
        return this.messagePolicy;
    }

    public boolean addRenewPolicy() {
        return this.addRenewPolicy;
    }

    public boolean getReqClientEntropy() {
        return this.reqClientEntropy;
    }

    public boolean isSymmetricBinding() {
        return this.symBinding != null;
    }

    public int getKeySize() {
        return this.skl;
    }

    public Token getSCToken() {
        return this.scToken;
    }

    public WSDLPort getWSDLPort() {
        return this.wsdlPort;
    }

    public WSBinding getWSBinding() {
        return this.wsBinding;
    }

    public Pipe getClientPipe() {
        return this.clientSecurityPipe;
    }

    public WSITClientAuthContext getWSITClientAuthContext() {
        return this.wsitClientAuthContext;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addVer;
    }
}

