/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.runtime.sequence.DefaultInMemorySequenceManager;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class SequenceManagerFactory {
    private static SequenceManagerFactory INSTANCE;
    private static ReadWriteLock INIT_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequenceManagerFactory getInstance() {
        INIT_LOCK.readLock().lock();
        try {
            if (INSTANCE == null) {
                INIT_LOCK.readLock().unlock();
                INIT_LOCK.writeLock().lock();
                try {
                    if (INSTANCE == null) {
                        INSTANCE = SequenceManagerFactory.initFactory();
                    }
                }
                finally {
                    INIT_LOCK.readLock().lock();
                    INIT_LOCK.writeLock().unlock();
                }
            }
            SequenceManagerFactory sequenceManagerFactory = INSTANCE;
            return sequenceManagerFactory;
        }
        finally {
            INIT_LOCK.readLock().unlock();
        }
    }

    private static SequenceManagerFactory initFactory() {
        return new SequenceManagerFactory(){

            public SequenceManager getSequenceManager() {
                return new DefaultInMemorySequenceManager();
            }
        };
    }

    protected SequenceManagerFactory() {
    }

    public abstract SequenceManager getSequenceManager();

    static {
        INIT_LOCK = new ReentrantReadWriteLock();
    }
}

