/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceData;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundSequence
extends AbstractSequence {
    private static final RmLogger LOGGER = RmLogger.getLogger(OutboundSequence.class);

    public OutboundSequence(SequenceData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextMessageId() throws MessageNumberRolloverException {
        try {
            this.data.acquireMessageIdDataReadWriteLock();
            long nextId = this.data.incrementAndGetLastMessageId();
            if (nextId > Long.MAX_VALUE) {
                throw LOGGER.logSevereException(new MessageNumberRolloverException(this.data.getSequenceId(), nextId));
            }
            this.data.addUnackedMessageId(nextId);
            long l = nextId;
            return l;
        }
        finally {
            this.data.releaseMessageIdDataReadWriteLock();
        }
    }

    @Override
    public long getLastMessageId() {
        return this.data.getLastMessageId();
    }

    @Override
    public void acknowledgeMessageId(long messageId) {
        this.data.removeUnackedMessageId(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) throws IllegalMessageIdentifierException {
        try {
            this.data.acquireMessageIdDataReadWriteLock();
            if (ranges == null || ranges.isEmpty() || this.data.noUnackedMessageIds()) {
                return;
            }
            if (ranges.size() > 1) {
                Collections.sort(ranges, new Comparator<Sequence.AckRange>(){

                    @Override
                    public int compare(Sequence.AckRange range1, Sequence.AckRange range2) {
                        if (range1.lower <= range2.lower) {
                            return -1;
                        }
                        return 1;
                    }
                });
            }
            Iterator<Long> unackedIterator = this.data.getAllUnackedIndexes().iterator();
            Iterator<Sequence.AckRange> rangeIterator = ranges.iterator();
            Sequence.AckRange currentRange = rangeIterator.next();
            while (unackedIterator.hasNext()) {
                long unackedIndex = unackedIterator.next();
                if (unackedIndex >= currentRange.lower && unackedIndex <= currentRange.upper) {
                    unackedIterator.remove();
                    continue;
                }
                if (rangeIterator.hasNext()) {
                    currentRange = rangeIterator.next();
                    continue;
                }
                break;
            }
        }
        finally {
            this.data.releaseMessageIdDataReadWriteLock();
        }
    }
}

