/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence
implements Sequence {
    protected final SequenceData data;

    protected AbstractSequence(SequenceData data) {
        this.data = data;
    }

    @Override
    public String getId() {
        return this.data.getSequenceId();
    }

    @Override
    public long getNextMessageId() throws MessageNumberRolloverException {
        throw new UnsupportedOperationException(LocalizationMessages.WSRM_1101_UNSUPPORTED_INTERFACE_OPERATION_IN_IMPLEMENTATION(Sequence.class.getName()));
    }

    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageIds() {
        if (this.getLastMessageId() == 0L) {
            return Collections.emptyList();
        }
        if (this.data.noUnackedMessageIds()) {
            return Arrays.asList(new Sequence.AckRange(1L, this.getLastMessageId()));
        }
        LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
        Collection<Long> unackedIndexes = this.data.getAllUnackedIndexes();
        long lastUnacked = unackedIndexes.iterator().next();
        if (lastUnacked > 1L) {
            result.add(new Sequence.AckRange(1L, lastUnacked - 1L));
        }
        for (long unackedIndex : unackedIndexes) {
            if (unackedIndex > lastUnacked + 1L) {
                result.add(new Sequence.AckRange(lastUnacked + 1L, unackedIndex - 1L));
            }
            lastUnacked = unackedIndex;
        }
        return result;
    }

    @Override
    public boolean hasPendingAcknowledgements() {
        return !this.data.noUnackedMessageIds();
    }

    @Override
    public Sequence.Status getStatus() {
        return this.data.getStatus();
    }

    protected void setStatus(Sequence.Status newStatus) {
        this.data.setStatus(newStatus);
    }

    @Override
    public void setAckRequestedFlag() {
        this.data.setAckRequestedFlag(true);
    }

    protected void clearAckRequestedFlag() {
        this.data.setAckRequestedFlag(false);
    }

    @Override
    public boolean isAckRequested() {
        return this.data.isAckRequestedFlag();
    }

    @Override
    public void close() {
        this.data.setStatus(Sequence.Status.CLOSED);
    }

    @Override
    public boolean isClosed() {
        return this.data.getStatus() == Sequence.Status.CLOSING || this.data.getStatus() == Sequence.Status.CLOSED || this.data.getStatus() == Sequence.Status.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.data.getExpirationTime() == -1L ? false : System.currentTimeMillis() < this.data.getExpirationTime();
    }

    @Override
    public void preDestroy() {
    }
}

