/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.RmWsException;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.policy.Rm11ServiceConfiguration;
import com.sun.xml.ws.rm.policy.assertion.AckRequestIntervalClientAssertion;
import com.sun.xml.ws.rm.policy.assertion.CloseTimeoutClientAssertion;
import com.sun.xml.ws.rm.policy.assertion.ResendIntervalClientAssertion;

class Rm11ClientConfiguration
implements Configuration {
    private final Configuration destinationConfig;
    private final long retransmittionInterval;
    private final boolean exponentialBackoff;
    private final long ackRequestInterval;
    private final long closeSequenceOperationTimeout;

    public Rm11ClientConfiguration(AssertionSet alternative, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseDetected) throws RmWsException {
        this.destinationConfig = new Rm11ServiceConfiguration(alternative, soapVersion, addressingVersion, requestResponseDetected);
        AckRequestIntervalClientAssertion ackIntervalAssertion = ConfigurationManager.extractAssertion(alternative, AckRequestIntervalClientAssertion.NAME, AckRequestIntervalClientAssertion.class);
        this.ackRequestInterval = ackIntervalAssertion != null ? ackIntervalAssertion.getInterval() : -1L;
        CloseTimeoutClientAssertion closeTimeoutAssertion = ConfigurationManager.extractAssertion(alternative, CloseTimeoutClientAssertion.NAME, CloseTimeoutClientAssertion.class);
        this.closeSequenceOperationTimeout = closeTimeoutAssertion != null ? closeTimeoutAssertion.getTimeout() : 3000L;
        ResendIntervalClientAssertion resendIntervalAssertion = ConfigurationManager.extractAssertion(alternative, ResendIntervalClientAssertion.NAME, ResendIntervalClientAssertion.class);
        this.retransmittionInterval = resendIntervalAssertion != null ? resendIntervalAssertion.getInterval() : -1L;
        this.exponentialBackoff = false;
    }

    public long getMessageRetransmissionInterval() {
        return this.retransmittionInterval;
    }

    public boolean useExponetialBackoffRetransmission() {
        return this.exponentialBackoff;
    }

    public long getAcknowledgementRequestInterval() {
        return this.ackRequestInterval;
    }

    public long getCloseSequenceOperationTimeout() {
        return this.closeSequenceOperationTimeout;
    }

    public RmVersion getRmVersion() {
        return this.destinationConfig.getRmVersion();
    }

    public SOAPVersion getSoapVersion() {
        return this.destinationConfig.getSoapVersion();
    }

    public AddressingVersion getAddressingVersion() {
        return this.destinationConfig.getAddressingVersion();
    }

    public boolean requestResponseOperationsDetected() {
        return this.destinationConfig.requestResponseOperationsDetected();
    }

    public long getInactivityTimeout() {
        return this.destinationConfig.getInactivityTimeout();
    }

    public long getSequenceAcknowledgementInterval() {
        return this.destinationConfig.getSequenceAcknowledgementInterval();
    }

    public Configuration.SecurityBinding getSecurityBinding() {
        return this.destinationConfig.getSecurityBinding();
    }

    public Configuration.DeliveryAssurance getDeliveryAssurance() {
        return this.destinationConfig.getDeliveryAssurance();
    }

    public boolean isOrderedDelivery() {
        return this.destinationConfig.isOrderedDelivery();
    }

    public long getDestinationBufferQuota() {
        return this.destinationConfig.getDestinationBufferQuota();
    }
}

