/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.saml2.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionStatement;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XACMLAuthzDecisionStatementImpl
implements XACMLAuthzDecisionStatement {
    private Response response = null;
    private Request request = null;
    private boolean mutable = true;

    public XACMLAuthzDecisionStatementImpl() {
    }

    public XACMLAuthzDecisionStatementImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("DecisionImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public XACMLAuthzDecisionStatementImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (response == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.response = response;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.request = request;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String xacmlSamlNsPrefix = "";
        String xacmlSamlNsDeclaration = "";
        if (declareNS) {
            xacmlSamlNsDeclaration = " xmlns:xacml-saml=\"urn:oasis:names:tc:xacml:2.0:saml:assertion:schema:os\" ";
        }
        if (includeNSPrefix) {
            xacmlSamlNsPrefix = " xacml-saml:";
        }
        sb.append("\n<").append(XACMLConstants.SAML_NS_PREFIX).append("Statement").append(XACMLConstants.SAML_NS_DECLARATION).append(" xsi:type=\"xacml-saml:XACMLAuthzDecisionStatement\"").append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append(" xmlns:xacml-saml=\"urn:oasis:names:tc:xacml:2.0:saml:assertion:schema:os\" ").append(">\n");
        if (this.response != null) {
            sb.append(this.response.toXMLString(includeNSPrefix, true));
        }
        if (this.request != null) {
            sb.append(this.request.toXMLString(includeNSPrefix, true));
        }
        sb.append("</").append(XACMLConstants.SAML_NS_PREFIX).append("Statement").append(">");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("DecisionImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("DecisionImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("Statement")) {
            XACMLSDKUtils.debug.error("DecisionImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numOfNodes; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            childElements.add(child);
        }
        int childCount = childElements.size();
        if (childCount < 1) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        if (childCount > 2) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        Element firstChild = (Element)childElements.get(0);
        String firstChildName = firstChild.getLocalName();
        if (!firstChildName.equals("Response")) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid first child element: " + firstChildName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_first_child"));
        }
        this.response = ContextFactory.getInstance().createResponse(firstChild);
        if (childCount > 1) {
            Element secondChild = (Element)childElements.get(1);
            String secondChildName = secondChild.getLocalName();
            if (!secondChildName.equals(XACMLConstants.REQUEST)) {
                XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid second child element: " + secondChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_second_child"));
            }
            this.request = ContextFactory.getInstance().createRequest(secondChild);
            if (childCount > 2) {
                Element thirdChild = (Element)childElements.get(2);
                String thirdChildName = thirdChild.getLocalName();
                XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid third child element: " + thirdChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_third_child"));
            }
        }
    }
}

