/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.SecurityTokenSpec;
import com.sun.identity.wss.security.TokenProvider;
import com.sun.identity.wss.security.WSSUtils;

public class SecurityTokenFactory {
    private TokenProvider tokenProvider = null;

    protected SecurityTokenFactory(TokenProvider provider) {
        this.tokenProvider = provider;
    }

    public static SecurityTokenFactory getInstance(SSOToken credential) throws SecurityException {
        try {
            return new SecurityTokenFactory(new AMTokenProvider(credential));
        }
        catch (SSOException se) {
            WSSUtils.debug.error("SecurityTokenFactory.getInstance: Unable to get the factory instance", se);
            throw new SecurityException(se.getMessage());
        }
    }

    public static SecurityTokenFactory getInstance(TokenProvider provider) throws SecurityException {
        if (provider == null) {
            throw new IllegalArgumentException(WSSUtils.bundle.getString("nullTokenProvider"));
        }
        return new SecurityTokenFactory(provider);
    }

    public SecurityToken getSecurityToken(SecurityTokenSpec tokenSpec) throws SecurityException {
        this.tokenProvider.init(tokenSpec);
        return this.tokenProvider.getSecurityToken();
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }
}

