/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.AssertionTokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AssertionToken
implements SecurityToken {
    private SSOToken ssoToken = null;
    private String authType = "";
    private String authTime = "";
    private String certAlias = null;
    private Assertion assertion = null;
    private static final String KEY_INFO_TYPE = "com.sun.identity.liberty.ws.security.keyinfotype";
    private static String keyInfoType = SystemConfigurationUtil.getProperty("com.sun.identity.liberty.ws.security.keyinfotype");

    public AssertionToken(AssertionTokenSpec spec, SSOToken ssoToken) throws SecurityException {
        if (spec == null) {
            WSSUtils.debug.error("AssertionToken: constructor: Assertion Token specification is null");
            throw new SecurityException(WSSUtils.bundle.getString("tokenSpecNotSpecified"));
        }
        this.validateSSOToken(ssoToken);
        this.createAssertion(spec);
    }

    private void validateSSOToken(SSOToken ssoToken) throws SecurityException {
        try {
            SSOTokenManager.getInstance().validateToken(ssoToken);
            this.authType = ssoToken.getAuthType();
            this.authTime = ssoToken.getProperty("authInstant");
        }
        catch (SSOException se) {
            WSSUtils.debug.error("AssertionToken.validateSSOToken: SSOException", se);
            throw new SecurityException(WSSUtils.bundle.getString("invalidSSOToken"));
        }
    }

    private void createAssertion(AssertionTokenSpec spec) throws SecurityException {
        SecurityMechanism securityMechanism = spec.getSecurityMechanism();
        NameIdentifier nameIdentifier = spec.getSenderIdentity();
        this.certAlias = spec.getSubjectCertAlias();
        if (nameIdentifier == null || securityMechanism == null || this.certAlias == null) {
            throw new SecurityException(WSSUtils.bundle.getString("invalidAssertionTokenSpec"));
        }
        String confirmationMethod = this.getConfirmationMethod(securityMechanism.getURI());
        String issuer = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
        Date issueInstant = new Date();
        AuthenticationStatement authStatement = this.createAuthenticationStatement(nameIdentifier, confirmationMethod);
        HashSet<AuthenticationStatement> statements = new HashSet<AuthenticationStatement>();
        if (authStatement != null) {
            statements.add(authStatement);
        }
        if (WSSUtils.debug.messageEnabled()) {
            WSSUtils.debug.message("AssertionToken.createAssertion: Assertion constructs:\nConfirmation method: " + confirmationMethod + "\n" + "Issuer: " + issuer + "\n");
        }
        try {
            this.assertion = new Assertion("", issuer, issueInstant, statements);
        }
        catch (SAMLException se) {
            WSSUtils.debug.error("AssertionToken.createAssertion: SAMLException in creating the assertion.", se);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoGenerateAssertion"));
        }
    }

    private String getConfirmationMethod(String securityURI) throws SecurityException {
        if (securityURI == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullSecurityMechanism"));
        }
        if (securityURI.equals("urn:sun:wss:security:null:SAMLToken-HK") || securityURI.equals("urn:sun:wss:security:TLS:SAMLToken-HK") || securityURI.equals("urn:sun:wss:security:ClientTLS:SAMLToken-HK")) {
            return "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        }
        if (securityURI.equals("urn:sun:wss:security:null:SAMLToken-SV") || securityURI.equals("urn:sun:wss:security:TLS:SAMLToken-SV") || securityURI.equals("urn:sun:wss:security:ClientTLS:SAMLToken-SV")) {
            return "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        }
        throw new SecurityException(WSSUtils.bundle.getString("invalidConfirmationMethod"));
    }

    private AuthenticationStatement createAuthenticationStatement(NameIdentifier nameIdentifier, String confirmationMethod) throws SecurityException {
        AuthenticationStatement authStatement = null;
        String authMethod = WSSUtils.getAuthMethodURI(this.authType);
        try {
            Date authInstant = DateUtils.stringToDate(this.authTime);
            Subject subject = null;
            if (confirmationMethod == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullConfirmationMethod"));
            }
            SubjectConfirmation subConfirmation = null;
            if (confirmationMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
                subConfirmation = new SubjectConfirmation(confirmationMethod);
                subConfirmation.setKeyInfo(this.createKeyInfo());
            } else if (confirmationMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches")) {
                subConfirmation = new SubjectConfirmation(confirmationMethod);
            } else {
                throw new SecurityException(WSSUtils.bundle.getString("invalidConfirmationMethod"));
            }
            subject = new Subject(nameIdentifier, subConfirmation);
            authStatement = new AuthenticationStatement(authMethod, authInstant, subject);
        }
        catch (SAMLException se) {
            WSSUtils.debug.error("AssertionToken.getAuthenticationStatement:Failed to generate the authentication statement.", se);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoGenerateAssertion"));
        }
        catch (ParseException pe) {
            WSSUtils.debug.error("AssertionToken.getAuthenticationStatement:Failed to generate the authentication statement.", pe);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoGenerateAssertion"));
        }
        return authStatement;
    }

    public String getTokenType() {
        return "urn:sun:wss:samltoken";
    }

    public Element toDocumentElement() throws SecurityException {
        Document document = XMLUtils.toDOMDocument(this.assertion.toString(true, true), WSSUtils.debug);
        if (document == null) {
            throw new SecurityException(WSSUtils.bundle.getString("cannotConvertToDocument"));
        }
        return document.getDocumentElement();
    }

    public AssertionToken(Element element) throws SAMLException {
        this.assertion = new Assertion(element);
    }

    public boolean isSenderVouches() {
        Set statements = this.assertion.getStatement();
        if (statements == null || statements.isEmpty()) {
            return false;
        }
        for (Object statement : statements) {
            Set confirmationMethods;
            SubjectConfirmation sc;
            Subject subject;
            if (!(statement instanceof SubjectStatement) || (subject = ((SubjectStatement)statement).getSubject()) == null || (sc = subject.getSubjectConfirmation()) == null || (confirmationMethods = sc.getConfirmationMethod()) == null || confirmationMethods.isEmpty() || !confirmationMethods.contains("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches")) continue;
            return true;
        }
        return false;
    }

    public X509Certificate getX509Certificate() throws SecurityException {
        X509Certificate cert = AMTokenProvider.getKeyProvider().getX509Certificate(this.certAlias);
        if (cert == null) {
            WSSUtils.debug.error("AssertionToken.getX509Certificate: Could not get certificate for alias : " + this.certAlias);
            throw new SecurityException(WSSUtils.bundle.getString("noCertificate"));
        }
        return cert;
    }

    private Element createKeyInfo() throws SecurityException {
        X509Certificate cert = this.getX509Certificate();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        String keyNameTextString = null;
        String base64CertString = null;
        PublicKey pk = null;
        try {
            pk = cert.getPublicKey();
            keyNameTextString = cert.getSubjectDN().getName();
            base64CertString = Base64.encode(cert.getEncoded());
        }
        catch (Exception e) {
            WSSUtils.debug.error("AssertionToken.createKeyInfo: ", e);
            throw new SecurityException(e.getMessage());
        }
        Element keyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        keyInfo.setAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoType != null && keyInfoType.equalsIgnoreCase("certificate")) {
            Element x509Data = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            Element x509Certificate = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            Text certText = doc.createTextNode(base64CertString);
            x509Certificate.appendChild(certText);
            keyInfo.appendChild(x509Data).appendChild(x509Certificate);
        } else {
            Element keyName = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            Text keyNameText = doc.createTextNode(keyNameTextString);
            Element keyvalue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            if (pk.getAlgorithm().equals("DSA")) {
                DSAPublicKey dsakey = (DSAPublicKey)pk;
                DSAParams dsaParams = dsakey.getParams();
                BigInteger _p = dsaParams.getP();
                BigInteger _q = dsaParams.getQ();
                BigInteger _g = dsaParams.getG();
                BigInteger _y = dsakey.getY();
                Element DSAKeyValue2 = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
                Element p = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "P");
                Text value_p = doc.createTextNode(Base64.encode(_p.toByteArray()));
                p.appendChild(value_p);
                DSAKeyValue2.appendChild(p);
                Element q = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Q");
                Text value_q = doc.createTextNode(Base64.encode(_q.toByteArray()));
                q.appendChild(value_q);
                DSAKeyValue2.appendChild(q);
                Element g = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "G");
                Text value_g = doc.createTextNode(Base64.encode(_g.toByteArray()));
                g.appendChild(value_g);
                DSAKeyValue2.appendChild(g);
                Element y = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Y");
                Text value_y = doc.createTextNode(Base64.encode(_y.toByteArray()));
                y.appendChild(value_y);
                DSAKeyValue2.appendChild(y);
                keyvalue.appendChild(DSAKeyValue2);
            } else {
                RSAPublicKey rsakey = (RSAPublicKey)pk;
                BigInteger exponent = rsakey.getPublicExponent();
                BigInteger modulus = rsakey.getModulus();
                Element RSAKeyValue2 = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
                Element modulusNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
                Element exponentNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
                RSAKeyValue2.appendChild(modulusNode);
                RSAKeyValue2.appendChild(exponentNode);
                Text modulusValue = doc.createTextNode(Base64.encode(modulus.toByteArray()));
                modulusNode.appendChild(modulusValue);
                Text exponentValue = doc.createTextNode(Base64.encode(exponent.toByteArray()));
                exponentNode.appendChild(exponentValue);
                keyvalue.appendChild(RSAKeyValue2);
            }
            keyInfo.appendChild(keyName).appendChild(keyNameText);
            keyInfo.appendChild(keyvalue);
        }
        return keyInfo;
    }

    public void sign(String alias) throws SecurityException {
        try {
            this.assertion.signXML(alias);
        }
        catch (SAMLException se) {
            WSSUtils.debug.error("AssertionToken.sign: exception", se);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoSign"));
        }
    }

    public Assertion getAssertion() {
        return this.assertion;
    }
}

